/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.util.RequireUtils;

public abstract class COSNumber
extends COSBase {
    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int intValue();

    public abstract long longValue();

    public static COSNumber get(String number) throws IOException {
        RequireUtils.requireNotNullArg(number, "Number cannot be null");
        RequireUtils.requireArg(number.matches("(E|e|\\+|\\-|\\.|\\d)+"), "Invalid number " + number);
        if (number.length() == 1) {
            char digit = number.charAt(0);
            if ('0' <= digit && digit <= '9') {
                return COSInteger.get(digit - 48);
            }
            return COSInteger.ZERO;
        }
        if (number.indexOf(46) == -1 && number.toLowerCase().indexOf(101) == -1) {
            try {
                return COSInteger.get(Long.parseLong(number));
            }
            catch (NumberFormatException e) {
                return COSInteger.ZERO;
            }
        }
        return new COSFloat(number);
    }
}

