/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSVisitor;

public final class COSName
extends COSBase
implements Comparable<COSName> {
    private static Map<String, COSName> CUSTOM_NAMES = new ConcurrentHashMap<String, COSName>(8192);
    private static Map<String, COSName> COMMON_NAMES = new HashMap<String, COSName>();
    public static final COSName A = COSName.newCommonInstance("A");
    public static final COSName AA = COSName.newCommonInstance("AA");
    public static final COSName ACRO_FORM = COSName.newCommonInstance("AcroForm");
    public static final COSName ACTUAL_TEXT = COSName.newCommonInstance("ActualText");
    public static final COSName ADBE_PKCS7_DETACHED = COSName.newCommonInstance("adbe.pkcs7.detached");
    public static final COSName ADBE_PKCS7_SHA1 = COSName.newCommonInstance("adbe.pkcs7.sha1");
    public static final COSName ADBE_X509_RSA_SHA1 = COSName.newCommonInstance("adbe.x509.rsa_sha1");
    public static final COSName ADOBE_PPKLITE = COSName.newCommonInstance("Adobe.PPKLite");
    public static final COSName AESV2 = COSName.newCommonInstance("AESV2");
    public static final COSName AESV3 = COSName.newCommonInstance("AESV3");
    public static final COSName AF = COSName.newCommonInstance("AF");
    public static final COSName AFTER = COSName.newCommonInstance("After");
    public static final COSName AIS = COSName.newCommonInstance("AIS");
    public static final COSName ALT = COSName.newCommonInstance("Alt");
    public static final COSName ALPHA = COSName.newCommonInstance("Alpha");
    public static final COSName ALTERNATE = COSName.newCommonInstance("Alternate");
    public static final COSName ANNOT = COSName.newCommonInstance("Annot");
    public static final COSName ANNOTS = COSName.newCommonInstance("Annots");
    public static final COSName ANTI_ALIAS = COSName.newCommonInstance("AntiAlias");
    public static final COSName AP = COSName.newCommonInstance("AP");
    public static final COSName AP_REF = COSName.newCommonInstance("APRef");
    public static final COSName APP = COSName.newCommonInstance("App");
    public static final COSName ART_BOX = COSName.newCommonInstance("ArtBox");
    public static final COSName ARTIFACT = COSName.newCommonInstance("Artifact");
    public static final COSName AS = COSName.newCommonInstance("AS");
    public static final COSName ASCENT = COSName.newCommonInstance("Ascent");
    public static final COSName ASCII_HEX_DECODE = COSName.newCommonInstance("ASCIIHexDecode");
    public static final COSName ASCII_HEX_DECODE_ABBREVIATION = COSName.newCommonInstance("AHx");
    public static final COSName ASCII85_DECODE = COSName.newCommonInstance("ASCII85Decode");
    public static final COSName ASCII85_DECODE_ABBREVIATION = COSName.newCommonInstance("A85");
    public static final COSName ATTACHED = COSName.newCommonInstance("Attached");
    public static final COSName AUTHOR = COSName.newCommonInstance("Author");
    public static final COSName AUTEVENT = COSName.newCommonInstance("AuthEvent");
    public static final COSName AVG_WIDTH = COSName.newCommonInstance("AvgWidth");
    public static final COSName B = COSName.newCommonInstance("B");
    public static final COSName BACKGROUND = COSName.newCommonInstance("Background");
    public static final COSName BASE_ENCODING = COSName.newCommonInstance("BaseEncoding");
    public static final COSName BASE_FONT = COSName.newCommonInstance("BaseFont");
    public static final COSName BASE_STATE = COSName.newCommonInstance("BaseState");
    public static final COSName BBOX = COSName.newCommonInstance("BBox");
    public static final COSName BC = COSName.newCommonInstance("BC");
    public static final COSName BE = COSName.newCommonInstance("BE");
    public static final COSName BEFORE = COSName.newCommonInstance("Before");
    public static final COSName BG = COSName.newCommonInstance("BG");
    public static final COSName BITS_PER_COMPONENT = COSName.newCommonInstance("BitsPerComponent");
    public static final COSName BITS_PER_COORDINATE = COSName.newCommonInstance("BitsPerCoordinate");
    public static final COSName BITS_PER_FLAG = COSName.newCommonInstance("BitsPerFlag");
    public static final COSName BITS_PER_SAMPLE = COSName.newCommonInstance("BitsPerSample");
    public static final COSName BLACK_IS_1 = COSName.newCommonInstance("BlackIs1");
    public static final COSName BLACK_POINT = COSName.newCommonInstance("BlackPoint");
    public static final COSName BLEED_BOX = COSName.newCommonInstance("BleedBox");
    public static final COSName BM = COSName.newCommonInstance("BM");
    public static final COSName BORDER = COSName.newCommonInstance("Border");
    public static final COSName BOUNDS = COSName.newCommonInstance("Bounds");
    public static final COSName BPC = COSName.newCommonInstance("BPC");
    public static final COSName BS = COSName.newCommonInstance("BS");
    public static final COSName BTN = COSName.newCommonInstance("Btn");
    public static final COSName BYTERANGE = COSName.newCommonInstance("ByteRange");
    public static final COSName C = COSName.newCommonInstance("C");
    public static final COSName C0 = COSName.newCommonInstance("C0");
    public static final COSName C1 = COSName.newCommonInstance("C1");
    public static final COSName CA = COSName.newCommonInstance("CA");
    public static final COSName CA_NS = COSName.newCommonInstance("ca");
    public static final COSName CALGRAY = COSName.newCommonInstance("CalGray");
    public static final COSName CALRGB = COSName.newCommonInstance("CalRGB");
    public static final COSName CAP = COSName.newCommonInstance("Cap");
    public static final COSName CAP_HEIGHT = COSName.newCommonInstance("CapHeight");
    public static final COSName CATALOG = COSName.newCommonInstance("Catalog");
    public static final COSName CCITTFAX_DECODE = COSName.newCommonInstance("CCITTFaxDecode");
    public static final COSName CCITTFAX_DECODE_ABBREVIATION = COSName.newCommonInstance("CCF");
    public static final COSName CENTER_WINDOW = COSName.newCommonInstance("CenterWindow");
    public static final COSName CF = COSName.newCommonInstance("CF");
    public static final COSName CFM = COSName.newCommonInstance("CFM");
    public static final COSName CH = COSName.newCommonInstance("Ch");
    public static final COSName CHAR_PROCS = COSName.newCommonInstance("CharProcs");
    public static final COSName CHAR_SET = COSName.newCommonInstance("CharSet");
    public static final COSName CI = COSName.newCommonInstance("CI");
    public static final COSName CICI_SIGNIT = COSName.newCommonInstance("CICI.SignIt");
    public static final COSName CID_FONT_TYPE0 = COSName.newCommonInstance("CIDFontType0");
    public static final COSName CID_FONT_TYPE2 = COSName.newCommonInstance("CIDFontType2");
    public static final COSName CID_TO_GID_MAP = COSName.newCommonInstance("CIDToGIDMap");
    public static final COSName CID_SET = COSName.newCommonInstance("CIDSet");
    public static final COSName CIDSYSTEMINFO = COSName.newCommonInstance("CIDSystemInfo");
    public static final COSName CL = COSName.newCommonInstance("CL");
    public static final COSName CLR_F = COSName.newCommonInstance("ClrF");
    public static final COSName CLR_FF = COSName.newCommonInstance("ClrFf");
    public static final COSName CMAP = COSName.newCommonInstance("CMap");
    public static final COSName CMAPNAME = COSName.newCommonInstance("CMapName");
    public static final COSName CMYK = COSName.newCommonInstance("CMYK");
    public static final COSName CO = COSName.newCommonInstance("CO");
    public static final COSName COLOR_BURN = COSName.newCommonInstance("ColorBurn");
    public static final COSName COLOR_DODGE = COSName.newCommonInstance("ColorDodge");
    public static final COSName COLORANTS = COSName.newCommonInstance("Colorants");
    public static final COSName COLORS = COSName.newCommonInstance("Colors");
    public static final COSName COLORSPACE = COSName.newCommonInstance("ColorSpace");
    public static final COSName COLUMNS = COSName.newCommonInstance("Columns");
    public static final COSName COMPATIBLE = COSName.newCommonInstance("Compatible");
    public static final COSName COMPONENTS = COSName.newCommonInstance("Components");
    public static final COSName CONTACT_INFO = COSName.newCommonInstance("ContactInfo");
    public static final COSName CONTENTS = COSName.newCommonInstance("Contents");
    public static final COSName COORDS = COSName.newCommonInstance("Coords");
    public static final COSName COUNT = COSName.newCommonInstance("Count");
    public static final COSName CP = COSName.newCommonInstance("CP");
    public static final COSName CREATION_DATE = COSName.newCommonInstance("CreationDate");
    public static final COSName CREATOR = COSName.newCommonInstance("Creator");
    public static final COSName CROP_BOX = COSName.newCommonInstance("CropBox");
    public static final COSName CRYPT = COSName.newCommonInstance("Crypt");
    public static final COSName CS = COSName.newCommonInstance("CS");
    public static final COSName D = COSName.newCommonInstance("D");
    public static final COSName DA = COSName.newCommonInstance("DA");
    public static final COSName DARKEN = COSName.newCommonInstance("Darken");
    public static final COSName DATAPREP = COSName.newCommonInstance("DataPrep");
    public static final COSName DATE = COSName.newCommonInstance("Date");
    public static final COSName DCT_DECODE = COSName.newCommonInstance("DCTDecode");
    public static final COSName DCT_DECODE_ABBREVIATION = COSName.newCommonInstance("DCT");
    public static final COSName DECODE = COSName.newCommonInstance("Decode");
    public static final COSName DECODE_PARMS = COSName.newCommonInstance("DecodeParms");
    public static final COSName DEFAULT = COSName.newCommonInstance("default");
    public static final COSName DEFAULT_CMYK = COSName.newCommonInstance("DefaultCMYK");
    public static final COSName DEFAULT_GRAY = COSName.newCommonInstance("DefaultGray");
    public static final COSName DEFAULT_RGB = COSName.newCommonInstance("DefaultRGB");
    public static final COSName DESC = COSName.newCommonInstance("Desc");
    public static final COSName DESCENDANT_FONTS = COSName.newCommonInstance("DescendantFonts");
    public static final COSName DESCENT = COSName.newCommonInstance("Descent");
    public static final COSName DEST = COSName.newCommonInstance("Dest");
    public static final COSName DEST_OUTPUT_PROFILE = COSName.newCommonInstance("DestOutputProfile");
    public static final COSName DESTS = COSName.newCommonInstance("Dests");
    public static final COSName DEVICECMYK = COSName.newCommonInstance("DeviceCMYK");
    public static final COSName DEVICEGRAY = COSName.newCommonInstance("DeviceGray");
    public static final COSName DEVICEN = COSName.newCommonInstance("DeviceN");
    public static final COSName DEVICERGB = COSName.newCommonInstance("DeviceRGB");
    public static final COSName DI = COSName.newCommonInstance("Di");
    public static final COSName DIFFERENCE = COSName.newCommonInstance("Difference");
    public static final COSName DIFFERENCES = COSName.newCommonInstance("Differences");
    public static final COSName DIGEST_METHOD = COSName.newCommonInstance("DigestMethod");
    public static final COSName DIGEST_RIPEMD160 = COSName.newCommonInstance("RIPEMD160");
    public static final COSName DIGEST_SHA1 = COSName.newCommonInstance("SHA1");
    public static final COSName DIGEST_SHA256 = COSName.newCommonInstance("SHA256");
    public static final COSName DIGEST_SHA384 = COSName.newCommonInstance("SHA384");
    public static final COSName DIGEST_SHA512 = COSName.newCommonInstance("SHA512");
    public static final COSName DIRECTION = COSName.newCommonInstance("Direction");
    public static final COSName DISPLAY_DOC_TITLE = COSName.newCommonInstance("DisplayDocTitle");
    public static final COSName DL = COSName.newCommonInstance("DL");
    public static final COSName DM = COSName.newCommonInstance("Dm");
    public static final COSName DOC = COSName.newCommonInstance("Doc");
    public static final COSName DOC_CHECKSUM = COSName.newCommonInstance("DocChecksum");
    public static final COSName DOC_OPEN = COSName.newCommonInstance("DocOpen");
    public static final COSName DOC_TIME_STAMP = COSName.newCommonInstance("DocTimeStamp");
    public static final COSName DOCMDP = COSName.newCommonInstance("DocMDP");
    public static final COSName DOMAIN = COSName.newCommonInstance("Domain");
    public static final COSName DOS = COSName.newCommonInstance("DOS");
    public static final COSName DP = COSName.newCommonInstance("DP");
    public static final COSName DR = COSName.newCommonInstance("DR");
    public static final COSName DS = COSName.newCommonInstance("DS");
    public static final COSName DUPLEX = COSName.newCommonInstance("Duplex");
    public static final COSName DUR = COSName.newCommonInstance("Dur");
    public static final COSName DV = COSName.newCommonInstance("DV");
    public static final COSName DW = COSName.newCommonInstance("DW");
    public static final COSName DW2 = COSName.newCommonInstance("DW2");
    public static final COSName E = COSName.newCommonInstance("E");
    public static final COSName EARLY_CHANGE = COSName.newCommonInstance("EarlyChange");
    public static final COSName EF = COSName.newCommonInstance("EF");
    public static final COSName EMBEDDED_FDFS = COSName.newCommonInstance("EmbeddedFDFs");
    public static final COSName EMBEDDED_FILE = COSName.newCommonInstance("EmbeddedFile");
    public static final COSName EMBEDDED_FILES = COSName.newCommonInstance("EmbeddedFiles");
    public static final COSName EMPTY = COSName.newCommonInstance("");
    public static final COSName ENCODE = COSName.newCommonInstance("Encode");
    public static final COSName ENCODED_BYTE_ALIGN = COSName.newCommonInstance("EncodedByteAlign");
    public static final COSName ENCODING = COSName.newCommonInstance("Encoding");
    public static final COSName ENCODING_90MS_RKSJ_H = COSName.newCommonInstance("90ms-RKSJ-H");
    public static final COSName ENCODING_90MS_RKSJ_V = COSName.newCommonInstance("90ms-RKSJ-V");
    public static final COSName ENCODING_ETEN_B5_H = COSName.newCommonInstance("ETen-B5-H");
    public static final COSName ENCODING_ETEN_B5_V = COSName.newCommonInstance("ETen-B5-V");
    public static final COSName ENCRYPT = COSName.newCommonInstance("Encrypt");
    public static final COSName ENCRYPT_META_DATA = COSName.newCommonInstance("EncryptMetadata");
    public static final COSName END_OF_LINE = COSName.newCommonInstance("EndOfLine");
    public static final COSName ENTRUST_PPKEF = COSName.newCommonInstance("Entrust.PPKEF");
    public static final COSName EXCLUSION = COSName.newCommonInstance("Exclusion");
    public static final COSName EXT_G_STATE = COSName.newCommonInstance("ExtGState");
    public static final COSName EXTEND = COSName.newCommonInstance("Extend");
    public static final COSName EXTENDS = COSName.newCommonInstance("Extends");
    public static final COSName F = COSName.newCommonInstance("F");
    public static final COSName F_DECODE_PARMS = COSName.newCommonInstance("FDecodeParms");
    public static final COSName F_FILTER = COSName.newCommonInstance("FFilter");
    public static final COSName FB = COSName.newCommonInstance("FB");
    public static final COSName FDF = COSName.newCommonInstance("FDF");
    public static final COSName FF = COSName.newCommonInstance("Ff");
    public static final COSName FIELDS = COSName.newCommonInstance("Fields");
    public static final COSName FILESPEC = COSName.newCommonInstance("Filespec");
    public static final COSName FILTER = COSName.newCommonInstance("Filter");
    public static final COSName FIRST = COSName.newCommonInstance("First");
    public static final COSName FIRST_CHAR = COSName.newCommonInstance("FirstChar");
    public static final COSName FIT_WINDOW = COSName.newCommonInstance("FitWindow");
    public static final COSName FL = COSName.newCommonInstance("FL");
    public static final COSName FLAGS = COSName.newCommonInstance("Flags");
    public static final COSName FLATE_DECODE = COSName.newCommonInstance("FlateDecode");
    public static final COSName FLATE_DECODE_ABBREVIATION = COSName.newCommonInstance("Fl");
    public static final COSName FONT = COSName.newCommonInstance("Font");
    public static final COSName FONT_BBOX = COSName.newCommonInstance("FontBBox");
    public static final COSName FONT_DESC = COSName.newCommonInstance("FontDescriptor");
    public static final COSName FONT_FAMILY = COSName.newCommonInstance("FontFamily");
    public static final COSName FONT_FILE = COSName.newCommonInstance("FontFile");
    public static final COSName FONT_FILE2 = COSName.newCommonInstance("FontFile2");
    public static final COSName FONT_FILE3 = COSName.newCommonInstance("FontFile3");
    public static final COSName FONT_MATRIX = COSName.newCommonInstance("FontMatrix");
    public static final COSName FONT_NAME = COSName.newCommonInstance("FontName");
    public static final COSName FONT_STRETCH = COSName.newCommonInstance("FontStretch");
    public static final COSName FONT_WEIGHT = COSName.newCommonInstance("FontWeight");
    public static final COSName FORM = COSName.newCommonInstance("Form");
    public static final COSName FORMTYPE = COSName.newCommonInstance("FormType");
    public static final COSName FRM = COSName.newCommonInstance("FRM");
    public static final COSName FT = COSName.newCommonInstance("FT");
    public static final COSName FUNCTION = COSName.newCommonInstance("Function");
    public static final COSName FUNCTION_TYPE = COSName.newCommonInstance("FunctionType");
    public static final COSName FUNCTIONS = COSName.newCommonInstance("Functions");
    public static final COSName G = COSName.newCommonInstance("G");
    public static final COSName GAMMA = COSName.newCommonInstance("Gamma");
    public static final COSName GROUP = COSName.newCommonInstance("Group");
    public static final COSName GTS_PDFA1 = COSName.newCommonInstance("GTS_PDFA1");
    public static final COSName H = COSName.newCommonInstance("H");
    public static final COSName HARD_LIGHT = COSName.newCommonInstance("HardLight");
    public static final COSName HEIGHT = COSName.newCommonInstance("Height");
    public static final COSName HIDE_MENUBAR = COSName.newCommonInstance("HideMenubar");
    public static final COSName HIDE_TOOLBAR = COSName.newCommonInstance("HideToolbar");
    public static final COSName HIDE_WINDOWUI = COSName.newCommonInstance("HideWindowUI");
    public static final COSName I = COSName.newCommonInstance("I");
    public static final COSName IC = COSName.newCommonInstance("IC");
    public static final COSName ICCBASED = COSName.newCommonInstance("ICCBased");
    public static final COSName ID = COSName.newCommonInstance("ID");
    public static final COSName ID_TREE = COSName.newCommonInstance("IDTree");
    public static final COSName IDENTITY = COSName.newCommonInstance("Identity");
    public static final COSName IDENTITY_H = COSName.newCommonInstance("Identity-H");
    public static final COSName IDENTITY_V = COSName.newCommonInstance("Identity-V");
    public static final COSName IF = COSName.newCommonInstance("IF");
    public static final COSName IM = COSName.newCommonInstance("IM");
    public static final COSName IMAGE = COSName.newCommonInstance("Image");
    public static final COSName IMAGE_MASK = COSName.newCommonInstance("ImageMask");
    public static final COSName INDEX = COSName.newCommonInstance("Index");
    public static final COSName INDEXED = COSName.newCommonInstance("Indexed");
    public static final COSName INFO = COSName.newCommonInstance("Info");
    public static final COSName INKLIST = COSName.newCommonInstance("InkList");
    public static final COSName INTERPOLATE = COSName.newCommonInstance("Interpolate");
    public static final COSName IT = COSName.newCommonInstance("IT");
    public static final COSName ITALIC_ANGLE = COSName.newCommonInstance("ItalicAngle");
    public static final COSName JAVA_SCRIPT = COSName.newCommonInstance("JavaScript");
    public static final COSName JBIG2_DECODE = COSName.newCommonInstance("JBIG2Decode");
    public static final COSName JBIG2_GLOBALS = COSName.newCommonInstance("JBIG2Globals");
    public static final COSName JPX_DECODE = COSName.newCommonInstance("JPXDecode");
    public static final COSName JS = COSName.newCommonInstance("JS");
    public static final COSName K = COSName.newCommonInstance("K");
    public static final COSName KEYWORDS = COSName.newCommonInstance("Keywords");
    public static final COSName KIDS = COSName.newCommonInstance("Kids");
    public static final COSName L = COSName.newCommonInstance("L");
    public static final COSName LAB = COSName.newCommonInstance("Lab");
    public static final COSName LANG = COSName.newCommonInstance("Lang");
    public static final COSName LAST = COSName.newCommonInstance("Last");
    public static final COSName LAST_CHAR = COSName.newCommonInstance("LastChar");
    public static final COSName LAST_MODIFIED = COSName.newCommonInstance("LastModified");
    public static final COSName LC = COSName.newCommonInstance("LC");
    public static final COSName LE = COSName.newCommonInstance("LE");
    public static final COSName LEADING = COSName.newCommonInstance("Leading");
    public static final COSName LEGAL_ATTESTATION = COSName.newCommonInstance("LegalAttestation");
    public static final COSName LENGTH = COSName.newCommonInstance("Length");
    public static final COSName LENGTH1 = COSName.newCommonInstance("Length1");
    public static final COSName LENGTH2 = COSName.newCommonInstance("Length2");
    public static final COSName LIGHTEN = COSName.newCommonInstance("Lighten");
    public static final COSName LIMITS = COSName.newCommonInstance("Limits");
    public static final COSName LJ = COSName.newCommonInstance("LJ");
    public static final COSName LL = COSName.newCommonInstance("LL");
    public static final COSName LLE = COSName.newCommonInstance("LLE");
    public static final COSName LLO = COSName.newCommonInstance("LLO");
    public static final COSName LOCATION = COSName.newCommonInstance("Location");
    public static final COSName LOCK = COSName.newCommonInstance("Lock");
    public static final COSName LUMINOSITY = COSName.newCommonInstance("Luminosity");
    public static final COSName LW = COSName.newCommonInstance("LW");
    public static final COSName LZW_DECODE = COSName.newCommonInstance("LZWDecode");
    public static final COSName LZW_DECODE_ABBREVIATION = COSName.newCommonInstance("LZW");
    public static final COSName M = COSName.newCommonInstance("M");
    public static final COSName MAC = COSName.newCommonInstance("Mac");
    public static final COSName MAC_EXPERT_ENCODING = COSName.newCommonInstance("MacExpertEncoding");
    public static final COSName MAC_ROMAN_ENCODING = COSName.newCommonInstance("MacRomanEncoding");
    public static final COSName MARK_INFO = COSName.newCommonInstance("MarkInfo");
    public static final COSName MASK = COSName.newCommonInstance("Mask");
    public static final COSName MATRIX = COSName.newCommonInstance("Matrix");
    public static final COSName MATTE = COSName.newCommonInstance("Matte");
    public static final COSName MAX_LEN = COSName.newCommonInstance("MaxLen");
    public static final COSName MAX_WIDTH = COSName.newCommonInstance("MaxWidth");
    public static final COSName MCID = COSName.newCommonInstance("MCID");
    public static final COSName MDP = COSName.newCommonInstance("MDP");
    public static final COSName MEDIA_BOX = COSName.newCommonInstance("MediaBox");
    public static final COSName METADATA = COSName.newCommonInstance("Metadata");
    public static final COSName MISSING_WIDTH = COSName.newCommonInstance("MissingWidth");
    public static final COSName MK = COSName.newCommonInstance("MK");
    public static final COSName ML = COSName.newCommonInstance("ML");
    public static final COSName MM_TYPE1 = COSName.newCommonInstance("MMType1");
    public static final COSName MOD_DATE = COSName.newCommonInstance("ModDate");
    public static final COSName MULTIPLY = COSName.newCommonInstance("Multiply");
    public static final COSName N = COSName.newCommonInstance("N");
    public static final COSName NAME = COSName.newCommonInstance("Name");
    public static final COSName NAMES = COSName.newCommonInstance("Names");
    public static final COSName NEED_APPEARANCES = COSName.newCommonInstance("NeedAppearances");
    public static final COSName NEXT = COSName.newCommonInstance("Next");
    public static final COSName NM = COSName.newCommonInstance("NM");
    public static final COSName NON_EFONT_NO_WARN = COSName.newCommonInstance("NonEFontNoWarn");
    public static final COSName NON_FULL_SCREEN_PAGE_MODE = COSName.newCommonInstance("NonFullScreenPageMode");
    public static final COSName NONE = COSName.newCommonInstance("None");
    public static final COSName NORMAL = COSName.newCommonInstance("Normal");
    public static final COSName NUMS = COSName.newCommonInstance("Nums");
    public static final COSName O = COSName.newCommonInstance("O");
    public static final COSName OBJ = COSName.newCommonInstance("Obj");
    public static final COSName OBJ_STM = COSName.newCommonInstance("ObjStm");
    public static final COSName OC = COSName.newCommonInstance("OC");
    public static final COSName OCG = COSName.newCommonInstance("OCG");
    public static final COSName OCGS = COSName.newCommonInstance("OCGs");
    public static final COSName OCPROPERTIES = COSName.newCommonInstance("OCProperties");
    public static final COSName OE = COSName.newCommonInstance("OE");
    public static final COSName OFF = COSName.newCommonInstance("OFF");
    public static final COSName Off = COSName.newCommonInstance("Off");
    public static final COSName ON = COSName.newCommonInstance("ON");
    public static final COSName OP = COSName.newCommonInstance("OP");
    public static final COSName OP_NS = COSName.newCommonInstance("op");
    public static final COSName OPEN_ACTION = COSName.newCommonInstance("OpenAction");
    public static final COSName OPEN_TYPE = COSName.newCommonInstance("OpenType");
    public static final COSName OPM = COSName.newCommonInstance("OPM");
    public static final COSName OPT = COSName.newCommonInstance("Opt");
    public static final COSName ORDER = COSName.newCommonInstance("Order");
    public static final COSName ORDERING = COSName.newCommonInstance("Ordering");
    public static final COSName OS = COSName.newCommonInstance("OS");
    public static final COSName OUTLINES = COSName.newCommonInstance("Outlines");
    public static final COSName OUTPUT_CONDITION = COSName.newCommonInstance("OutputCondition");
    public static final COSName OUTPUT_CONDITION_IDENTIFIER = COSName.newCommonInstance("OutputConditionIdentifier");
    public static final COSName OUTPUT_INTENT = COSName.newCommonInstance("OutputIntent");
    public static final COSName OUTPUT_INTENTS = COSName.newCommonInstance("OutputIntents");
    public static final COSName OVERLAY = COSName.newCommonInstance("Overlay");
    public static final COSName P = COSName.newCommonInstance("P");
    public static final COSName PAGE = COSName.newCommonInstance("Page");
    public static final COSName PAGE_LABELS = COSName.newCommonInstance("PageLabels");
    public static final COSName PAGE_LAYOUT = COSName.newCommonInstance("PageLayout");
    public static final COSName PAGE_MODE = COSName.newCommonInstance("PageMode");
    public static final COSName PAGES = COSName.newCommonInstance("Pages");
    public static final COSName PAINT_TYPE = COSName.newCommonInstance("PaintType");
    public static final COSName PANOSE = COSName.newCommonInstance("Panose");
    public static final COSName PARAMS = COSName.newCommonInstance("Params");
    public static final COSName PARENT = COSName.newCommonInstance("Parent");
    public static final COSName PARENT_TREE = COSName.newCommonInstance("ParentTree");
    public static final COSName PARENT_TREE_NEXT_KEY = COSName.newCommonInstance("ParentTreeNextKey");
    public static final COSName PATTERN = COSName.newCommonInstance("Pattern");
    public static final COSName PATTERN_TYPE = COSName.newCommonInstance("PatternType");
    public static final COSName PDF_DOC_ENCODING = COSName.newCommonInstance("PDFDocEncoding");
    public static final COSName PERMS = COSName.newCommonInstance("Perms");
    public static final COSName PG = COSName.newCommonInstance("Pg");
    public static final COSName PIECE_INFO = COSName.newCommonInstance("PieceInfo");
    public static final COSName PMD = COSName.newCommonInstance("PMD");
    public static final COSName POPUP = COSName.newCommonInstance("Popup");
    public static final COSName PRE_RELEASE = COSName.newCommonInstance("PreRelease");
    public static final COSName PREDICTOR = COSName.newCommonInstance("Predictor");
    public static final COSName PREV = COSName.newCommonInstance("Prev");
    public static final COSName PRINT_AREA = COSName.newCommonInstance("PrintArea");
    public static final COSName PRINT_CLIP = COSName.newCommonInstance("PrintClip");
    public static final COSName PRINT_SCALING = COSName.newCommonInstance("PrintScaling");
    public static final COSName PROC_SET = COSName.newCommonInstance("ProcSet");
    public static final COSName PROCESS = COSName.newCommonInstance("Process");
    public static final COSName PRODUCER = COSName.newCommonInstance("Producer");
    public static final COSName PROP_BUILD = COSName.newCommonInstance("Prop_Build");
    public static final COSName PROPERTIES = COSName.newCommonInstance("Properties");
    public static final COSName PS = COSName.newCommonInstance("PS");
    public static final COSName PUB_SEC = COSName.newCommonInstance("PubSec");
    public static final COSName Q = COSName.newCommonInstance("Q");
    public static final COSName QUADPOINTS = COSName.newCommonInstance("QuadPoints");
    public static final COSName R = COSName.newCommonInstance("R");
    public static final COSName RANGE = COSName.newCommonInstance("Range");
    public static final COSName RC = COSName.newCommonInstance("RC");
    public static final COSName RD = COSName.newCommonInstance("RD");
    public static final COSName REASON = COSName.newCommonInstance("Reason");
    public static final COSName REASONS = COSName.newCommonInstance("Reasons");
    public static final COSName RECIPIENTS = COSName.newCommonInstance("Recipients");
    public static final COSName RECT = COSName.newCommonInstance("Rect");
    public static final COSName REGISTRY = COSName.newCommonInstance("Registry");
    public static final COSName REGISTRY_NAME = COSName.newCommonInstance("RegistryName");
    public static final COSName RENAME = COSName.newCommonInstance("Rename");
    public static final COSName RESOURCES = COSName.newCommonInstance("Resources");
    public static final COSName RGB = COSName.newCommonInstance("RGB");
    public static final COSName RI = COSName.newCommonInstance("RI");
    public static final COSName ROLE_MAP = COSName.newCommonInstance("RoleMap");
    public static final COSName ROOT = COSName.newCommonInstance("Root");
    public static final COSName ROTATE = COSName.newCommonInstance("Rotate");
    public static final COSName ROWS = COSName.newCommonInstance("Rows");
    public static final COSName RUN_LENGTH_DECODE = COSName.newCommonInstance("RunLengthDecode");
    public static final COSName RUN_LENGTH_DECODE_ABBREVIATION = COSName.newCommonInstance("RL");
    public static final COSName RV = COSName.newCommonInstance("RV");
    public static final COSName S = COSName.newCommonInstance("S");
    public static final COSName SA = COSName.newCommonInstance("SA");
    public static final COSName SCREEN = COSName.newCommonInstance("Screen");
    public static final COSName SE = COSName.newCommonInstance("SE");
    public static final COSName SEPARATION = COSName.newCommonInstance("Separation");
    public static final COSName SET_F = COSName.newCommonInstance("SetF");
    public static final COSName SET_FF = COSName.newCommonInstance("SetFf");
    public static final COSName SHADING = COSName.newCommonInstance("Shading");
    public static final COSName SHADING_TYPE = COSName.newCommonInstance("ShadingType");
    public static final COSName SIG = COSName.newCommonInstance("Sig");
    public static final COSName SIG_FLAGS = COSName.newCommonInstance("SigFlags");
    public static final COSName SIZE = COSName.newCommonInstance("Size");
    public static final COSName SM = COSName.newCommonInstance("SM");
    public static final COSName SMASK = COSName.newCommonInstance("SMask");
    public static final COSName SOFT_LIGHT = COSName.newCommonInstance("SoftLight");
    public static final COSName SOUND = COSName.newCommonInstance("Sound");
    public static final COSName SS = COSName.newCommonInstance("SS");
    public static final COSName ST = COSName.newCommonInstance("St");
    public static final COSName STANDARD = COSName.newCommonInstance("Standard");
    public static final COSName STANDARD_ENCODING = COSName.newCommonInstance("StandardEncoding");
    public static final COSName STATE = COSName.newCommonInstance("State");
    public static final COSName STATE_MODEL = COSName.newCommonInstance("StateModel");
    public static final COSName STATUS = COSName.newCommonInstance("Status");
    public static final COSName STD_CF = COSName.newCommonInstance("StdCF");
    public static final COSName STEM_H = COSName.newCommonInstance("StemH");
    public static final COSName STEM_V = COSName.newCommonInstance("StemV");
    public static final COSName STM_F = COSName.newCommonInstance("StmF");
    public static final COSName STR_F = COSName.newCommonInstance("StrF");
    public static final COSName STRUCT_PARENT = COSName.newCommonInstance("StructParent");
    public static final COSName STRUCT_PARENTS = COSName.newCommonInstance("StructParents");
    public static final COSName STRUCT_TREE_ROOT = COSName.newCommonInstance("StructTreeRoot");
    public static final COSName STYLE = COSName.newCommonInstance("Style");
    public static final COSName SUB_FILTER = COSName.newCommonInstance("SubFilter");
    public static final COSName SUBJ = COSName.newCommonInstance("Subj");
    public static final COSName SUBJECT = COSName.newCommonInstance("Subject");
    public static final COSName SUBTYPE = COSName.newCommonInstance("Subtype");
    public static final COSName SUPPLEMENT = COSName.newCommonInstance("Supplement");
    public static final COSName SV = COSName.newCommonInstance("SV");
    public static final COSName SW = COSName.newCommonInstance("SW");
    public static final COSName T = COSName.newCommonInstance("T");
    public static final COSName TARGET = COSName.newCommonInstance("Target");
    public static final COSName TEMPLATES = COSName.newCommonInstance("Templates");
    public static final COSName THREADS = COSName.newCommonInstance("Threads");
    public static final COSName TI = COSName.newCommonInstance("TI");
    public static final COSName TILING_TYPE = COSName.newCommonInstance("TilingType");
    public static final COSName TIME_STAMP = COSName.newCommonInstance("TimeStamp");
    public static final COSName TITLE = COSName.newCommonInstance("Title");
    public static final COSName TK = COSName.newCommonInstance("TK");
    public static final COSName TM = COSName.newCommonInstance("TM");
    public static final COSName TO_UNICODE = COSName.newCommonInstance("ToUnicode");
    public static final COSName TR = COSName.newCommonInstance("TR");
    public static final COSName TR2 = COSName.newCommonInstance("TR2");
    public static final COSName TRAPPED = COSName.newCommonInstance("Trapped");
    public static final COSName TRANS = COSName.newCommonInstance("Trans");
    public static final COSName TRANSPARENCY = COSName.newCommonInstance("Transparency");
    public static final COSName TREF = COSName.newCommonInstance("TRef");
    public static final COSName TRIM_BOX = COSName.newCommonInstance("TrimBox");
    public static final COSName TRUE_TYPE = COSName.newCommonInstance("TrueType");
    public static final COSName TRUSTED_MODE = COSName.newCommonInstance("TrustedMode");
    public static final COSName TU = COSName.newCommonInstance("TU");
    public static final COSName TX = COSName.newCommonInstance("Tx");
    public static final COSName TYPE = COSName.newCommonInstance("Type");
    public static final COSName TYPE0 = COSName.newCommonInstance("Type0");
    public static final COSName TYPE1 = COSName.newCommonInstance("Type1");
    public static final COSName TYPE3 = COSName.newCommonInstance("Type3");
    public static final COSName U = COSName.newCommonInstance("U");
    public static final COSName UE = COSName.newCommonInstance("UE");
    public static final COSName UF = COSName.newCommonInstance("UF");
    public static final COSName UNCHANGED = COSName.newCommonInstance("Unchanged");
    public static final COSName UNIX = COSName.newCommonInstance("Unix");
    public static final COSName URI = COSName.newCommonInstance("URI");
    public static final COSName URL = COSName.newCommonInstance("URL");
    public static final COSName V = COSName.newCommonInstance("V");
    public static final COSName V2 = COSName.newCommonInstance("V2");
    public static final COSName VERISIGN_PPKVS = COSName.newCommonInstance("VeriSign.PPKVS");
    public static final COSName VERSION = COSName.newCommonInstance("Version");
    public static final COSName VERTICES = COSName.newCommonInstance("Vertices");
    public static final COSName VERTICES_PER_ROW = COSName.newCommonInstance("VerticesPerRow");
    public static final COSName VIEW_AREA = COSName.newCommonInstance("ViewArea");
    public static final COSName VIEW_CLIP = COSName.newCommonInstance("ViewClip");
    public static final COSName VIEWER_PREFERENCES = COSName.newCommonInstance("ViewerPreferences");
    public static final COSName W = COSName.newCommonInstance("W");
    public static final COSName W2 = COSName.newCommonInstance("W2");
    public static final COSName WHITE_POINT = COSName.newCommonInstance("WhitePoint");
    public static final COSName WIDGET = COSName.newCommonInstance("Widget");
    public static final COSName WIDTH = COSName.newCommonInstance("Width");
    public static final COSName WIDTHS = COSName.newCommonInstance("Widths");
    public static final COSName WIN_ANSI_ENCODING = COSName.newCommonInstance("WinAnsiEncoding");
    public static final COSName XFA = COSName.newCommonInstance("XFA");
    public static final COSName X_STEP = COSName.newCommonInstance("XStep");
    public static final COSName XHEIGHT = COSName.newCommonInstance("XHeight");
    public static final COSName XOBJECT = COSName.newCommonInstance("XObject");
    public static final COSName XREF = COSName.newCommonInstance("XRef");
    public static final COSName XREF_STM = COSName.newCommonInstance("XRefStm");
    public static final COSName Y_STEP = COSName.newCommonInstance("YStep");
    public static final COSName YES = COSName.newCommonInstance("Yes");
    private final String name;

    public static COSName getPDFName(String aName) {
        if (aName != null) {
            COSName cosName = COMMON_NAMES.get(aName);
            if (cosName != null) {
                return cosName;
            }
            return COSName.getCustom(aName);
        }
        return null;
    }

    private static COSName getCustom(String customName) {
        COSName value;
        COSName cosName = CUSTOM_NAMES.get(customName);
        if (cosName == null && (cosName = CUSTOM_NAMES.putIfAbsent(customName, value = new COSName(customName))) == null) {
            cosName = value;
        }
        return cosName;
    }

    private static COSName newCommonInstance(String commonName) {
        COSName value = new COSName(commonName);
        COMMON_NAMES.put(commonName, value);
        return value;
    }

    private COSName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "COSName{" + this.name + "}";
    }

    public boolean equals(Object object) {
        return object instanceof COSName && this.name.equals(((COSName)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(COSName other) {
        return this.name.compareTo(other.name);
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

