/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.ValidSingleOutput;

public class SingleOutputValidator
implements ConstraintValidator<ValidSingleOutput, SingleOutputTaskParameters> {
    @Override
    public void initialize(ValidSingleOutput constraintAnnotation) {
    }

    @Override
    public boolean isValid(SingleOutputTaskParameters value, ConstraintValidatorContext context) {
        if (Objects.nonNull(value)) {
            if (Objects.isNull(value.getOutput())) {
                return false;
            }
            if (Objects.isNull(value.getOutput().getDestination()) || value.getOutput().getDestination().exists() && (value.getExistingOutputPolicy() == ExistingOutputPolicy.FAIL || value.getExistingOutputPolicy() == ExistingOutputPolicy.SKIP)) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format("File destination already exists: %s.", value.getOutput().getDestination())).addConstraintViolation();
                return false;
            }
        }
        return true;
    }
}

