/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

public class SingleOutputExtensionsValidator
implements ConstraintValidator<SingleOutputAllowedExtensions, SingleOutputTaskParameters> {
    private String[] extensions;

    @Override
    public void initialize(SingleOutputAllowedExtensions constraintAnnotation) {
        this.extensions = constraintAnnotation.extensions();
    }

    @Override
    public boolean isValid(SingleOutputTaskParameters value, ConstraintValidatorContext context) {
        if (Objects.nonNull(value) && Objects.nonNull(value.getOutput()) && ArrayUtils.isNotEmpty(this.extensions)) {
            String fileName = value.getOutput().getDestination().getName();
            if (this.hasAllowedExtension(fileName)) {
                return true;
            }
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("The output '%s' is not one of the expected types: %s", fileName, ArrayUtils.toString(this.extensions))).addNode("taskOutput").addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean hasAllowedExtension(String fileName) {
        String extension = FilenameUtils.getExtension(fileName);
        for (String current : this.extensions) {
            if (!StringUtils.equalsIgnoreCase(current, extension) || FilenameUtils.indexOfExtension(fileName) <= 0) continue;
            return true;
        }
        return false;
    }
}

