/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.sejda.model.validation.constraint.NotNegative;

public class NotNegativeNumberValidator
implements ConstraintValidator<NotNegative, Number> {
    @Override
    public void initialize(NotNegative minValue) {
    }

    @Override
    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 1 || ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.ZERO) == 1 || ((BigInteger)value).compareTo(BigInteger.ZERO) == 0;
        }
        return value.floatValue() >= 0.0f;
    }
}

