/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.input.Source;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.validation.constraint.PositiveDimensions;
import org.sejda.model.watermark.Location;

public class WatermarkParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PageRangeSelection,
PagesSelection {
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();
    @Valid
    @NotNull
    private Source<?> watermark;
    @NotNull
    private Location location = Location.BEHIND;
    @Min(value=0L)
    @Max(value=100L)
    private int opacity = 100;
    @PositiveDimensions
    private Dimension dimension;
    @NotNull
    private Point2D position = new Point();
    private int rotationDegrees;

    public WatermarkParameters(Source<?> watermark) {
        this.watermark = watermark;
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    @Override
    public Set<Integer> getPages(int totalNumberOfPage) {
        if (this.pageSelection.isEmpty()) {
            return new PageRange(1).getPages(totalNumberOfPage);
        }
        return this.getPageSelection().stream().flatMap(r -> r.getPages(totalNumberOfPage).stream()).collect(NullSafeSet::new, NullSafeSet::add, NullSafeSet::addAll);
    }

    public Source<?> getWatermark() {
        return this.watermark;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimenstion) {
        this.dimension = dimenstion;
    }

    public int getRotationDegrees() {
        return this.rotationDegrees;
    }

    public void setRotationDegrees(int rotationDegrees) {
        this.rotationDegrees = rotationDegrees;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.watermark).append(this.pageSelection).append(this.location).append(this.dimension).append(this.opacity).append(this.position).append(this.rotationDegrees).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WatermarkParameters)) {
            return false;
        }
        WatermarkParameters parameter = (WatermarkParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.watermark, parameter.watermark).append(this.pageSelection, parameter.pageSelection).append(this.location, parameter.location).append(this.dimension, parameter.dimension).append(this.opacity, parameter.opacity).append(this.position, parameter.position).append(this.rotationDegrees, parameter.rotationDegrees).isEquals();
    }
}

