/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.parameter.PageSize;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.scale.Margins;

public class ResizePagesParameters
extends MultiplePdfSourceMultipleOutputParameters
implements PageRangeSelection,
PagesSelection {
    @Valid
    public Margins margins;
    public PageSize pageSize;
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    @Override
    public Set<Integer> getPages(int totalNumberOfPage) {
        if (this.pageSelection.isEmpty()) {
            return new PageRange(1).getPages(totalNumberOfPage);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(totalNumberOfPage));
        }
        return retSet;
    }

    public Margins getMargins() {
        return this.margins;
    }

    public void setMargins(Margins margins) {
        this.margins = margins;
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.margins).append(this.pageSelection).append(this.pageSize).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResizePagesParameters)) {
            return false;
        }
        ResizePagesParameters parameter = (ResizePagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.margins, parameter.margins).append(this.pageSize, parameter.pageSize).append(this.pageSelection, parameter.pageSelection).isEquals();
    }
}

