/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.parameter.base.SinglePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.validation.constraint.NotEmpty;

public class OcrTextByPagesParameters
extends SinglePdfSourceMultipleOutputParameters
implements PageRangeSelection,
PagesSelection {
    @Valid
    private final Set<PageRange> pageSelection = new NullSafeSet<PageRange>();
    @NotEmpty
    private String textEncoding = "UTF-8";
    public final Set<Locale> languages = new HashSet<Locale>();

    public void addLanguage(Locale language) {
        this.languages.add(language);
    }

    public Set<Locale> getLanguages() {
        return this.languages;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }

    @Override
    public Set<PageRange> getPageSelection() {
        return Collections.unmodifiableSet(this.pageSelection);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.add(range);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        this.pageSelection.addAll(ranges);
    }

    @Override
    public Set<Integer> getPages(int totalNumberOfPage) {
        if (this.pageSelection.isEmpty()) {
            return new PageRange(1).getPages(totalNumberOfPage);
        }
        NullSafeSet<Integer> retSet = new NullSafeSet<Integer>();
        for (PageRange range : this.getPageSelection()) {
            retSet.addAll(range.getPages(totalNumberOfPage));
        }
        return retSet;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.pageSelection).append(this.textEncoding).append(this.languages).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OcrTextByPagesParameters)) {
            return false;
        }
        OcrTextByPagesParameters parameter = (OcrTextByPagesParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.pageSelection, parameter.pageSelection).append(this.textEncoding, parameter.getTextEncoding()).append(this.languages, parameter.getLanguages()).isEquals();
    }
}

