/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.output.SingleTaskOutput;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.SingleOutputTaskParameters;
import org.sejda.model.validation.constraint.AtLeastTwo;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@SingleOutputAllowedExtensions
public class AlternateMixMultipleInputParameters
extends AbstractPdfOutputParameters
implements SingleOutputTaskParameters {
    @Valid
    @NotNull
    private SingleTaskOutput output;
    @Valid
    @AtLeastTwo
    private List<PdfMixInput> inputList = new ArrayList<PdfMixInput>();

    @Override
    public SingleTaskOutput getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(SingleTaskOutput output) {
        this.output = output;
    }

    public List<PdfMixInput> getInputList() {
        return Collections.unmodifiableList(this.inputList);
    }

    public void addInput(PdfMixInput input) {
        this.inputList.add(input);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.inputList).append(this.output).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlternateMixMultipleInputParameters)) {
            return false;
        }
        AlternateMixMultipleInputParameters parameter = (AlternateMixMultipleInputParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.inputList, parameter.inputList).append(this.output, parameter.getOutput()).isEquals();
    }
}

