/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.output;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.SingleOrMultipleTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;

public class FileOrDirectoryTaskOutput
implements SingleOrMultipleTaskOutput {
    private File file;

    public FileOrDirectoryTaskOutput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A not null file or directory instance is expected. Path: " + file);
        }
        this.file = file;
    }

    @Override
    public File getDestination() {
        return this.file;
    }

    @Override
    public void accept(TaskOutputDispatcher writer) throws TaskOutputVisitException {
        try {
            writer.dispatch(this);
        }
        catch (IOException e) {
            throw new TaskOutputVisitException("Exception dispatching the file or directory task output.", e);
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append(this.file).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.file).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileOrDirectoryTaskOutput)) {
            return false;
        }
        FileOrDirectoryTaskOutput output = (FileOrDirectoryTaskOutput)other;
        return new EqualsBuilder().append(this.file, output.file).isEquals();
    }

    public static FileOrDirectoryTaskOutput file(File file) {
        if (file == null || file.exists() && !file.isFile()) {
            throw new IllegalArgumentException("A valid instance is expected (not null or existing file).");
        }
        return new FileOrDirectoryTaskOutput(file);
    }

    public static FileOrDirectoryTaskOutput directory(File directory) {
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException("A not null directory instance is expected. Path: " + directory);
        }
        return new FileOrDirectoryTaskOutput(directory);
    }
}

