/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.output;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;

public class DirectoryTaskOutput
implements MultipleTaskOutput {
    private final File directory;

    public DirectoryTaskOutput(File directory) {
        if (Objects.isNull(directory) || directory.exists() && !directory.isDirectory()) {
            throw new IllegalArgumentException("A not null directory instance is expected. Path: " + directory);
        }
        this.directory = directory;
    }

    @Override
    public File getDestination() {
        return this.directory;
    }

    @Override
    public void accept(TaskOutputDispatcher writer) throws TaskOutputVisitException {
        try {
            writer.dispatch(this);
        }
        catch (IOException e) {
            throw new TaskOutputVisitException("Exception dispatching the file task output.", e);
        }
    }

    public String toString() {
        return this.directory.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.directory).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DirectoryTaskOutput)) {
            return false;
        }
        DirectoryTaskOutput output = (DirectoryTaskOutput)other;
        return new EqualsBuilder().append(this.directory, output.getDestination()).isEquals();
    }
}

