/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.util;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AcroFormUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AcroFormUtils.class);

    private AcroFormUtils() {
    }

    public static void mergeDefaults(PDAcroForm mergeThis, PDAcroForm intoThis) {
        int quadding;
        if (!intoThis.isNeedAppearances() && mergeThis.isNeedAppearances()) {
            intoThis.setNeedAppearances(true);
        }
        String da = mergeThis.getDefaultAppearance();
        if (StringUtils.isBlank(intoThis.getDefaultAppearance()) && !StringUtils.isBlank(da)) {
            intoThis.setDefaultAppearance(da);
        }
        if ((quadding = mergeThis.getCOSObject().getInt(COSName.Q)) >= 0 && quadding <= 2 && !intoThis.getCOSObject().containsKey(COSName.Q)) {
            intoThis.setQuadding(quadding);
        }
        COSDictionary formResources = Optional.ofNullable(intoThis.getCOSObject().getDictionaryObject(COSName.DR, COSDictionary.class)).orElseGet(COSDictionary::new);
        Optional.ofNullable(mergeThis.getCOSObject().getDictionaryObject(COSName.DR, COSDictionary.class)).ifPresent(dr -> {
            for (COSName currentKey : dr.keySet()) {
                Optional.ofNullable(dr.getDictionaryObject(currentKey)).ifPresent(value -> {
                    if (value instanceof COSDictionary) {
                        AcroFormUtils.mergeResourceDictionaryValue(formResources, (COSDictionary)value, currentKey);
                    } else if (value instanceof COSArray) {
                        AcroFormUtils.mergeResourceArrayValue(formResources, (COSArray)value, currentKey);
                    } else {
                        LOG.warn("Unsupported resource dictionary type {}", value);
                    }
                });
            }
        });
        intoThis.getCOSObject().setItem(COSName.DR, (COSBase)formResources);
        LOG.debug("Merged AcroForm dictionary");
    }

    private static void mergeResourceArrayValue(COSDictionary formResources, COSArray value, COSName currentKey) {
        COSArray currentItem = Optional.ofNullable(formResources.getDictionaryObject(currentKey, COSArray.class)).orElseGet(COSArray::new);
        value.stream().filter(i -> !currentItem.contains(i)).forEach(currentItem::add);
        formResources.setItem(currentKey, (COSBase)currentItem);
    }

    private static void mergeResourceDictionaryValue(COSDictionary formResources, COSDictionary value, COSName currentKey) {
        COSDictionary currentItem = Optional.ofNullable(formResources.getDictionaryObject(currentKey, COSDictionary.class)).orElseGet(COSDictionary::new);
        currentItem.mergeWithoutOverwriting(value);
        formResources.setItem(currentKey, (COSBase)currentItem);
    }
}

