/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.util.Objects;
import java.util.Optional;
import org.sejda.impl.sambox.component.optimization.ResourceDictionaryCleaner;
import org.sejda.impl.sambox.component.optimization.ResourcesHitter;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDResources;

class PageCopier {
    private boolean optimize;
    private ResourcesHitter hitter = new ResourcesHitter();
    private ResourceDictionaryCleaner cleaner = new ResourceDictionaryCleaner();

    public PageCopier(boolean optimize) {
        this.optimize = optimize;
    }

    public PDPage copyOf(PDPage page) {
        PDPage copy = new PDPage(page.getCOSObject().duplicate());
        copy.setCropBox(page.getCropBox());
        copy.setMediaBox(page.getMediaBox());
        copy.setResources(page.getResources());
        copy.setRotation(page.getRotation());
        copy.getCOSObject().removeItem(COSName.B);
        COSArray annots = page.getCOSObject().getDictionaryObject(COSName.ANNOTS, COSArray.class);
        if (Objects.nonNull(annots)) {
            COSArray cleanedAnnotationsCopy = new COSArray();
            annots.stream().map(COSBase::getCOSObject).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(COSDictionary::duplicate).forEach(a -> {
                a.removeItem(COSName.P);
                a.removeItem(COSName.DEST);
                a.removeItem(COSName.getPDFName("Popup"));
                a.removeItem(COSName.PARENT);
                if (Optional.ofNullable(a.getDictionaryObject(COSName.A, COSDictionary.class)).map(d -> d.containsKey(COSName.D)).orElse(false).booleanValue()) {
                    a.removeItem(COSName.A);
                }
                cleanedAnnotationsCopy.add((COSBase)a);
            });
            copy.getCOSObject().setItem(COSName.ANNOTS, (COSBase)cleanedAnnotationsCopy);
        }
        if (this.optimize) {
            COSDictionary resources = Optional.ofNullable(copy.getResources().getCOSObject()).map(COSDictionary::duplicate).orElseGet(COSDictionary::new);
            copy.setResources(new PDResources(resources));
            Optional.ofNullable(resources.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull).map(COSDictionary::duplicate).ifPresent(d -> resources.setItem(COSName.XOBJECT, (COSBase)d));
            Optional.ofNullable(resources.getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull).map(COSDictionary::duplicate).ifPresent(d -> resources.setItem(COSName.FONT, (COSBase)d));
            this.hitter.accept(copy);
            this.cleaner.clean(copy);
        }
        return copy;
    }
}

