/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimization;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.impl.sambox.component.optimization.InUseFontDictionary;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.MissingResourceException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.font.PDType3CharProc;
import org.sejda.sambox.pdmodel.font.PDType3Font;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesHitter
extends PDFStreamEngine
implements Consumer<PDPage> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesHitter.class);

    public ResourcesHitter() {
        this.addOperator(new XObjectOperator());
        this.addOperator(new FontHitterOperator());
    }

    private void processAnnotation(PDAnnotation annotation) throws IOException {
        List appreaceEntries = ((Collection)Optional.ofNullable(annotation.getAppearance()).map(d -> d.getCOSObject().getValues()).filter(Objects::nonNull).orElse(Collections.emptyList())).stream().map(a -> a.getCOSObject()).filter(a -> !(a instanceof COSNull)).map(PDAppearanceEntry::new).collect(Collectors.toList());
        for (PDAppearanceEntry entry : appreaceEntries) {
            if (entry.isStream()) {
                this.processStream(entry.getAppearanceStream());
                continue;
            }
            for (PDAppearanceStream stream : entry.getSubDictionary().values()) {
                this.processStream(stream);
            }
        }
    }

    @Override
    public void accept(PDPage page) {
        try {
            this.processPage(page);
            for (PDAnnotation annotation : page.getAnnotations()) {
                this.processAnnotation(annotation);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed parse page, skipping and continuing with next.", e);
        }
    }

    private class FontHitterOperator
    extends OperatorProcessor {
        private FontHitterOperator() {
        }

        @Override
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.size() < 2) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName fontName = (COSName)operand;
                Optional<COSDictionary> fonts = Optional.ofNullable(this.getContext().getResources()).map(r -> r.getCOSObject().getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull);
                COSBase existing = fonts.map(d -> d.getDictionaryObject(fontName)).orElseThrow(() -> new MissingResourceException("Missing font resource: " + fontName.getName()));
                if (!(existing instanceof InUseFontDictionary)) {
                    COSDictionary fontDictionary = Optional.of(existing).filter(e -> e instanceof COSDictionary).map(e -> (COSDictionary)e).orElseThrow(() -> new IllegalArgumentException("Font resource unexpected type"));
                    LOG.trace("Hit font with name {}", (Object)fontName.getName());
                    fonts.get().setItem(fontName, (COSBase)new InUseFontDictionary(fontDictionary));
                    if (COSName.TYPE3.equals(fontDictionary.getCOSName(COSName.SUBTYPE)) && Objects.isNull(fontDictionary.getItem(COSName.RESOURCES))) {
                        LOG.trace("Found type3 font with no resource dictionary {}", (Object)fontName.getName());
                        PDType3Font font = new PDType3Font(fontDictionary);
                        Collection glyphStreams = Optional.ofNullable(fontDictionary.getDictionaryObject(COSName.CHAR_PROCS, COSDictionary.class)).map(chars -> chars.getValues()).filter(v -> !v.isEmpty()).orElseGet(Collections::emptyList);
                        List pdStreams = glyphStreams.stream().map(COSBase::getCOSObject).filter(s -> s instanceof COSStream).map(s -> (COSStream)s).map(s -> new PDType3CharProc(font, (COSStream)s)).collect(Collectors.toList());
                        for (PDType3CharProc glyph : pdStreams) {
                            ResourcesHitter.this.processStream(glyph);
                        }
                    }
                }
            }
        }

        @Override
        public String getName() {
            return "Tf";
        }
    }

    private class XObjectOperator
    extends OperatorProcessor {
        private XObjectOperator() {
        }

        @Override
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.isEmpty()) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName objectName = (COSName)operand;
                Optional<COSDictionary> xobjects = Optional.ofNullable(this.getContext().getResources()).map(r -> r.getCOSObject().getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull);
                COSBase existing = xobjects.map(d -> d.getDictionaryObject(objectName)).orElseThrow(() -> new MissingResourceException("Missing XObject: " + objectName.getName()));
                if (existing instanceof COSStream) {
                    if (!(existing instanceof ReadOnlyFilteredCOSStream)) {
                        COSStream imageStream = (COSStream)existing;
                        LOG.trace("Hit image with name {}", (Object)objectName.getName());
                        xobjects.get().setItem(objectName, (COSBase)ReadOnlyFilteredCOSStream.readOnly(imageStream));
                        if (COSName.FORM.getName().equals(imageStream.getNameAsString(COSName.SUBTYPE))) {
                            PDXObject xobject = PDXObject.createXObject(imageStream, this.getContext().getResources());
                            if (xobject instanceof PDTransparencyGroup) {
                                this.getContext().showTransparencyGroup((PDTransparencyGroup)xobject);
                            } else if (xobject instanceof PDFormXObject) {
                                this.getContext().showForm((PDFormXObject)xobject);
                            }
                        }
                    }
                } else {
                    LOG.warn("Unexpected type {} for xObject {}", (Object)existing.getClass(), (Object)objectName.getName());
                }
            }
        }

        @Override
        public String getName() {
            return "Do";
        }
    }
}

