/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sejda.impl.sambox.component.OutlineItem;
import org.sejda.impl.sambox.component.OutlineUtils;
import org.sejda.model.outline.OutlineExtractPageDestinations;
import org.sejda.model.outline.OutlineLevelsHandler;
import org.sejda.model.outline.OutlinePageDestinations;
import org.sejda.sambox.pdmodel.PDDocument;

public class SamboxOutlineLevelsHandler
implements OutlineLevelsHandler {
    private Pattern titleMatchingPattern = Pattern.compile(".+");
    private PDDocument document;

    public SamboxOutlineLevelsHandler(PDDocument document, String matchingTitleRegEx) {
        Objects.requireNonNull(document, "Unable to retrieve bookmarks from a null document.");
        this.document = document;
        if (StringUtils.isNotBlank(matchingTitleRegEx)) {
            this.titleMatchingPattern = Pattern.compile(matchingTitleRegEx);
        }
    }

    @Override
    public OutlinePageDestinations getPageDestinationsForLevel(int level) {
        OutlinePageDestinations destinations = new OutlinePageDestinations();
        OutlineUtils.getFlatOutline(this.document).stream().filter(i -> i.level == level).filter(i -> StringUtils.isNotBlank(i.title)).filter(i -> this.titleMatchingPattern.matcher(i.title).matches()).forEach(i -> destinations.addPage(i.page, i.title));
        return destinations;
    }

    @Override
    public OutlineExtractPageDestinations getExtractPageDestinations(int level, boolean includePageAfter) {
        OutlineExtractPageDestinations destinations = new OutlineExtractPageDestinations();
        List<OutlineItem> flatOutline = OutlineUtils.getFlatOutline(this.document);
        for (int i = 0; i < flatOutline.size(); ++i) {
            OutlineItem item = flatOutline.get(i);
            if (item.level != level) continue;
            int startPage = item.page;
            String title = item.title;
            if (!StringUtils.isNotBlank(title) || !this.titleMatchingPattern.matcher(title).matches()) continue;
            int endPage = this.document.getNumberOfPages();
            for (int j = i + 1; j < flatOutline.size(); ++j) {
                OutlineItem after = flatOutline.get(j);
                if (after.level > item.level) continue;
                endPage = includePageAfter ? after.page : after.page - 1;
                break;
            }
            if (startPage == 1 && endPage == 0) {
                endPage = 1;
            }
            destinations.add(startPage, title, endPage);
        }
        return destinations;
    }
}

