/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Optional;
import org.sejda.impl.sambox.component.PageImageWriter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.WatermarkParameters;
import org.sejda.model.watermark.Location;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroupAttributes;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;

public class PdfWatermarker {
    private PageImageWriter imageWriter;
    private PDFormXObject form;
    private WatermarkParameters parameters;

    public PdfWatermarker(WatermarkParameters parameters, PDDocument document) throws TaskIOException {
        this.imageWriter = new PageImageWriter(document);
        this.parameters = parameters;
        PDImageXObject watermark = PageImageWriter.toPDXImageObject(parameters.getWatermark());
        this.form = new PDFormXObject();
        this.form.setResources(new PDResources());
        PDTransparencyGroupAttributes group = new PDTransparencyGroupAttributes();
        group.setKnockout();
        this.form.setGroup(group);
        PDRectangle bbox = Optional.ofNullable(parameters.getDimension()).map(d -> new PDRectangle((float)d.getWidth(), (float)d.getHeight())).orElseGet(() -> new PDRectangle(watermark.getWidth(), watermark.getHeight()));
        this.form.setBBox(bbox);
        int degrees = parameters.getRotationDegrees() % 360;
        if (degrees < 0) {
            degrees += 360;
        }
        if (degrees != 0) {
            AffineTransform at = this.form.getMatrix().createAffineTransform();
            at.rotate(Math.toRadians(degrees), bbox.getWidth() / 2.0f, bbox.getHeight() / 2.0f);
            this.form.setMatrix(at);
        }
        try (PDPageContentStream contentStream = new PDPageContentStream(document, this.form);){
            contentStream.drawImage(watermark, 0.0f, 0.0f, this.form.getBBox().getWidth(), this.form.getBBox().getHeight());
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred writing form xobject stream.", e);
        }
    }

    public void mark(PDPage page) throws TaskIOException {
        PDExtendedGraphicsState gs = null;
        if (this.parameters.getOpacity() != 100) {
            gs = new PDExtendedGraphicsState();
            float alpha = (float)this.parameters.getOpacity() / 100.0f;
            gs.setStrokingAlphaConstant(Float.valueOf(alpha));
            gs.setNonStrokingAlphaConstant(Float.valueOf(alpha));
        }
        if (this.parameters.getLocation() == Location.BEHIND) {
            this.imageWriter.prepend(page, this.form, (Point2D)page.cropBoxCoordinatesToDraw(this.parameters.getPosition()), 1.0f, 1.0f, gs, page.getRotation());
        } else {
            this.imageWriter.append(page, this.form, (Point2D)page.cropBoxCoordinatesToDraw(this.parameters.getPosition()), 1.0f, 1.0f, gs, page.getRotation());
        }
    }
}

