/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.text.PDFTextStripper;
import org.sejda.sambox.text.TextPosition;

public class PdfVisibleTextStripper
extends PDFTextStripper
implements Closeable {
    public PdfVisibleTextStripper(Writer outputWriter) throws IOException {
        this.setShouldSeparateByBeads(false);
        this.output = outputWriter;
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        if (text.isVisible()) {
            super.processTextPosition(text);
        }
    }

    public void extract(PDPage page) throws TaskIOException {
        try {
            this.setSortByPosition(true);
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            if (page.hasContents()) {
                this.processPage(page);
            }
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred extracting text from page.", e);
        }
    }

    @Override
    protected void endPage(PDPage page) {
        Iterator<PDStream> iter = page.getContentStreams();
        while (iter.hasNext()) {
            iter.next().getCOSObject().unDecode();
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.output);
    }
}

