/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import org.sejda.common.LookupTable;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfAlternateMixer;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskPermissionsException;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfMixFragment
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PdfAlternateMixer.class);
    private LookupTable<PDPage> lookups = new LookupTable();
    private PDDocumentHandler handler;
    private PdfMixInput input;
    private LinkedList<Integer> pages;

    private PdfMixFragment(PdfMixInput input, PDDocumentHandler handler) {
        this.pages = new LinkedList<Integer>(input.getPages(handler.getNumberOfPages()));
        this.handler = handler;
        this.input = input;
    }

    public PDPage nextPage() {
        if (this.input.isReverse()) {
            return this.handler.getPage(this.pages.removeLast());
        }
        return this.handler.getPage(this.pages.removeFirst());
    }

    public boolean hasNextPage() {
        return !this.pages.isEmpty();
    }

    public int getNumberOfPages() {
        return this.handler.getNumberOfPages();
    }

    public int getStep() {
        return this.input.getStep();
    }

    public void addLookupEntry(PDPage current, PDPage importPage) {
        this.lookups.addLookupEntry(current, importPage);
    }

    public void saintizeAnnotations() {
        SignatureClipper.clipSignatures(new AnnotationsDistiller(this.handler.getUnderlyingPDDocument()).retainRelevantAnnotations(this.lookups).values());
    }

    @Override
    public void close() throws IOException {
        this.handler.close();
        this.lookups.clear();
    }

    public static PdfMixFragment newInstance(PdfMixInput input) throws TaskIOException, TaskPermissionsException {
        LOG.debug("Opening input {} with step {} and reverse {}", input.getSource(), input.getStep(), input.isReverse());
        PDDocumentHandler documentHandler = input.getSource().open(new DefaultPdfSourceOpener());
        documentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
        return new PdfMixFragment(input, documentHandler);
    }
}

