/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfMixFragment;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;

public class PdfAlternateMixer
extends PDDocumentHandler {
    private List<PdfMixFragment> mixFragments = new ArrayList<PdfMixFragment>();
    private int currentStep = 0;

    public void mix(List<PdfMixInput> inputs, TaskExecutionContext executionContext) throws TaskException {
        this.setCreatorOnPDDocument();
        for (PdfMixInput input : inputs) {
            this.mixFragments.add(PdfMixFragment.newInstance(input));
        }
        int totalSteps = this.mixFragments.stream().map(PdfMixFragment::getNumberOfPages).reduce(0, (curr, value) -> curr + value);
        while (this.mixFragments.stream().anyMatch(PdfMixFragment::hasNextPage)) {
            executionContext.assertTaskNotCancelled();
            this.mixFragments.stream().filter(PdfMixFragment::hasNextPage).forEach(f -> {
                for (int i = 0; i < f.getStep() && f.hasNextPage(); ++i) {
                    PDPage current = f.nextPage();
                    f.addLookupEntry(current, this.importPage(current));
                    ApplicationEventsNotifier.notifyEvent(executionContext.notifiableTaskMetadata()).stepsCompleted(++this.currentStep).outOf(totalSteps);
                }
            });
        }
        this.mixFragments.stream().forEach(PdfMixFragment::saintizeAnnotations);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mixFragments.stream().forEach(ComponentsUtility::nullSafeCloseQuietly);
        this.mixFragments.clear();
        this.currentStep = 0;
    }
}

