/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.AcroFormsMerger;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.OutlineDistiller;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.impl.sambox.component.optimization.ResourceDictionaryCleaner;
import org.sejda.impl.sambox.component.optimization.ResourcesHitter;
import org.sejda.model.exception.TaskCancelledException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesExtractor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PagesExtractor.class);
    private OutlineDistiller outlineMerger;
    private AcroFormsMerger acroFormsMerger;
    private PDDocument origin;
    private PDDocumentHandler destinationDocument;
    private LookupTable<PDPage> pagesLookup = new LookupTable();

    public PagesExtractor(PDDocument origin) {
        this.origin = origin;
        this.init();
    }

    private void init() {
        this.outlineMerger = new OutlineDistiller(this.origin);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.initialiseBasedOn(this.origin);
        this.acroFormsMerger = new AcroFormsMerger(AcroFormPolicy.MERGE, this.destinationDocument.getUnderlyingPDDocument());
    }

    public void retain(Set<Integer> pages, TaskExecutionContext executionContext) throws TaskCancelledException, TaskExecutionException {
        int currentStep = 0;
        for (Integer page : pages) {
            executionContext.assertTaskNotCancelled();
            this.retain(page, executionContext);
            ApplicationEventsNotifier.notifyEvent(executionContext.notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(pages.size());
        }
    }

    public void retain(int page, TaskExecutionContext executionContext) throws TaskExecutionException {
        try {
            PDPage existingPage = this.origin.getPage(page - 1);
            this.pagesLookup.addLookupEntry(existingPage, this.destinationDocument.importPage(existingPage));
            LOG.trace("Imported page number {}", (Object)page);
        }
        catch (PageNotFoundException e) {
            executionContext.assertTaskIsLenient(e);
            ApplicationEventsNotifier.notifyEvent(executionContext.notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be processed", page), e);
        }
    }

    public void setVersion(PdfVersion version) {
        this.destinationDocument.setVersionOnPDDocument(version);
    }

    public void setCompress(boolean compress) {
        this.destinationDocument.setCompress(compress);
    }

    public void optimize() {
        LOG.trace("Optimizing document");
        ResourcesHitter hitter = new ResourcesHitter();
        this.pagesLookup.values().forEach(p -> {
            COSDictionary resources = Optional.ofNullable(p.getResources().getCOSObject()).map(COSDictionary::duplicate).orElseGet(COSDictionary::new);
            p.setResources(new PDResources(resources));
            Optional.ofNullable(resources.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull).map(COSDictionary::duplicate).ifPresent(d -> resources.setItem(COSName.XOBJECT, (COSBase)d));
            Optional.ofNullable(resources.getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull).map(COSDictionary::duplicate).ifPresent(d -> resources.setItem(COSName.FONT, (COSBase)d));
            hitter.accept((PDPage)p);
        });
        new ResourceDictionaryCleaner().accept(this.destinationDocument.getUnderlyingPDDocument());
    }

    public void save(File file, boolean discardOutline) throws TaskException {
        if (!discardOutline) {
            this.createOutline();
        }
        LookupTable<PDAnnotation> annotations = new AnnotationsDistiller(this.origin).retainRelevantAnnotations(this.pagesLookup);
        SignatureClipper.clipSignatures(annotations.values());
        this.acroFormsMerger.mergeForm(this.origin.getDocumentCatalog().getAcroForm(), annotations);
        Optional.ofNullable(this.acroFormsMerger.getForm()).filter(f -> !f.getFields().isEmpty()).ifPresent(f -> {
            LOG.debug("Adding generated AcroForm");
            this.destinationDocument.setDocumentAcroForm((PDAcroForm)f);
        });
        this.destinationDocument.savePDDocument(file);
    }

    private void createOutline() {
        PDDocumentOutline outline = new PDDocumentOutline();
        this.outlineMerger.appendRelevantOutlineTo(outline, this.pagesLookup);
        if (outline.hasChildren()) {
            this.destinationDocument.setDocumentOutline(outline);
        }
    }

    @Override
    public void close() {
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
        this.pagesLookup.clear();
        this.outlineMerger = null;
    }

    protected PDDocumentHandler destinationDocument() {
        return this.destinationDocument;
    }

    public void reset() {
        this.close();
        this.init();
    }
}

