/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.Objects;
import java.util.Optional;
import org.sejda.common.LookupTable;
import org.sejda.impl.sambox.component.OutlineUtils;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineDistiller {
    private static final Logger LOG = LoggerFactory.getLogger(OutlineDistiller.class);
    private PDDocument document;

    public OutlineDistiller(PDDocument document) {
        RequireUtils.requireNotNullArg(document, "Unable to retrieve bookmarks from a null document.");
        this.document = document;
    }

    public void appendRelevantOutlineTo(PDOutlineNode to, LookupTable<PDPage> pagesLookup) {
        Objects.requireNonNull(to, "Unable to merge relevant outline items to a null outline.");
        if (!pagesLookup.isEmpty()) {
            Optional.ofNullable(this.document.getDocumentCatalog().getDocumentOutline()).ifPresent(outline -> {
                for (PDOutlineItem child : outline.children()) {
                    this.cloneNode(child, pagesLookup).ifPresent(c -> to.addLast((PDOutlineItem)c));
                }
                LOG.debug("Appended relevant outline items");
            });
        }
    }

    private Optional<PDOutlineItem> cloneNode(PDOutlineItem node, LookupTable<PDPage> pagesLookup) {
        if (node.hasChildren()) {
            PDOutlineItem clone = new PDOutlineItem();
            for (PDOutlineItem current : node.children()) {
                this.cloneNode(current, pagesLookup).ifPresent(clonedChild -> clone.addLast((PDOutlineItem)clonedChild));
            }
            Optional<PDPageDestination> pageDestination = OutlineUtils.toPageDestination(node, this.document.getDocumentCatalog());
            Optional<PDPage> destinationPage = pageDestination.map(PDPageDestination::getPage).map(p -> pagesLookup.lookup((PDPage)p));
            if (clone.hasChildren() || destinationPage.isPresent()) {
                OutlineUtils.copyOutlineDictionary(node, clone);
                destinationPage.ifPresent(p -> clone.setDestination(OutlineUtils.clonePageDestination((PDPageDestination)pageDestination.get(), p)));
                return Optional.of(clone);
            }
            return Optional.empty();
        }
        return this.cloneLeafIfNeeded(node, pagesLookup);
    }

    private Optional<PDOutlineItem> cloneLeafIfNeeded(PDOutlineItem origin, LookupTable<PDPage> pagesLookup) {
        return OutlineUtils.toPageDestination(origin, this.document.getDocumentCatalog()).flatMap(d -> {
            PDPage mapped = pagesLookup.lookup(d.getPage());
            if (mapped != null) {
                PDOutlineItem retVal = new PDOutlineItem();
                OutlineUtils.copyOutlineDictionary(origin, retVal);
                retVal.setDestination(OutlineUtils.clonePageDestination(d, mapped));
                return Optional.of(retVal);
            }
            return Optional.empty();
        });
    }
}

