/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Color;
import java.io.IOException;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.HorizontalAlign;
import org.sejda.model.VerticalAlign;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilenameFooterWriter {
    private static final Logger LOG = LoggerFactory.getLogger(FilenameFooterWriter.class);
    private boolean addFooter = false;
    private PageTextWriter writer;
    private static PDFont FONT = PDType1Font.HELVETICA;
    private static double FONT_SIZE = 10.0;

    public FilenameFooterWriter(boolean addFooter, PDDocument document) {
        this.writer = new PageTextWriter(document);
        this.addFooter = addFooter;
    }

    public void addFooter(PDPage page, String fileName, long pageNumber) throws TaskException {
        if (this.addFooter) {
            try {
                String truncatedFilename = this.truncateIfRequired(fileName, this.maxWidth(page, pageNumber));
                this.writer.write(page, HorizontalAlign.LEFT, VerticalAlign.BOTTOM, truncatedFilename, FONT, FONT_SIZE, Color.BLACK);
                this.writer.write(page, HorizontalAlign.RIGHT, VerticalAlign.BOTTOM, Long.toString(pageNumber), FONT, FONT_SIZE, Color.BLACK);
            }
            catch (IOException | TaskIOException e) {
                throw new TaskException("Unable to write the page footer", e);
            }
        }
    }

    private double maxWidth(PDPage page, long pageNumber) throws IOException {
        PDRectangle pageSize = page.getMediaBox().rotate(page.getRotation());
        return (double)(pageSize.getWidth() - 2.0f * PageTextWriter.DEFAULT_MARGIN.floatValue()) - FontUtils.getSimpleStringWidth(Long.toString(pageNumber), FONT, FONT_SIZE);
    }

    private double stringWidth(String text) throws TaskIOException {
        return this.writer.getStringWidth(text, FONT, (float)FONT_SIZE);
    }

    private String truncateIfRequired(String text, double maxWidth) throws TaskIOException {
        if (this.stringWidth(text) <= maxWidth) {
            return text;
        }
        LOG.debug("Page filename footer needs truncating to fit available space");
        int currentLength = text.length() / 2;
        while (this.stringWidth(text.substring(0, currentLength)) > maxWidth) {
            currentLength /= 2;
        }
        int currentChunk = currentLength;
        while (currentChunk > 1) {
            if (!(this.stringWidth(text.substring(0, currentLength + (currentChunk /= 2))) < maxWidth)) continue;
            currentLength += currentChunk;
        }
        return text.substring(0, currentLength);
    }
}

