/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sejda.common.LookupTable;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionGoTo;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationPopup;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationsDistiller {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationsDistiller.class);
    private PDDocument document;
    private LookupTable<PDAnnotation> annotationsLookup = new LookupTable();

    public AnnotationsDistiller(PDDocument document) {
        RequireUtils.requireNotNullArg(document, "Cannot process annotations for a null document");
        this.document = document;
    }

    public LookupTable<PDAnnotation> retainRelevantAnnotations(LookupTable<PDPage> relevantPages) {
        LOG.debug("Filtering annotations");
        for (PDPage page : relevantPages.keys()) {
            try {
                HashSet<PDAnnotation> keptAnnotations = new HashSet<PDAnnotation>();
                for (PDAnnotation annotation : page.getAnnotations()) {
                    if (this.annotationsLookup.hasLookupFor(annotation)) continue;
                    if (annotation instanceof PDAnnotationLink) {
                        this.processLinkAnnotation(relevantPages, keptAnnotations, (PDAnnotationLink)annotation);
                        continue;
                    }
                    this.processNonLinkAnnotation(relevantPages, keptAnnotations, annotation);
                }
                relevantPages.lookup(page).setAnnotations(new ArrayList<PDAnnotation>(keptAnnotations));
            }
            catch (IOException e) {
                LOG.warn("Failed to process annotations for page", e);
            }
        }
        return this.annotationsLookup;
    }

    private void processLinkAnnotation(LookupTable<PDPage> relevantPages, Set<PDAnnotation> keptAnnotations, PDAnnotationLink annotation) throws IOException {
        PDDestination destination = this.getDestinationFrom(annotation);
        if (destination instanceof PDPageDestination) {
            PDPage destPage = relevantPages.lookup(((PDPageDestination)destination).getPage());
            if (Objects.nonNull(destPage)) {
                PDAnnotationLink duplicate = (PDAnnotationLink)this.duplicate(annotation, relevantPages);
                duplicate.getCOSObject().removeItem(COSName.A);
                PDPageDestination newDestination = (PDPageDestination)PDDestination.create(((PDPageDestination)destination).getCOSObject().duplicate());
                newDestination.setPage(destPage);
                duplicate.setDestination(newDestination);
                keptAnnotations.add(duplicate);
            } else {
                LOG.trace("Removing not relevant link annotation");
            }
        } else {
            keptAnnotations.add(this.duplicate(annotation, relevantPages));
        }
    }

    private void processNonLinkAnnotation(LookupTable<PDPage> relevantPages, Set<PDAnnotation> keptAnnotations, PDAnnotation annotation) {
        PDPage p = annotation.getPage();
        if (Objects.isNull(p) || relevantPages.hasLookupFor(p)) {
            PDAnnotationPopup popup;
            PDAnnotation duplicate = this.duplicate(annotation, relevantPages);
            if (duplicate instanceof PDAnnotationMarkup && Objects.nonNull(popup = ((PDAnnotationMarkup)duplicate).getPopup())) {
                COSName subtype = popup.getCOSObject().getCOSName(COSName.SUBTYPE);
                if (COSName.POPUP.equals(subtype)) {
                    PDAnnotationPopup popupDuplicate = Optional.ofNullable((PDAnnotationPopup)this.annotationsLookup.lookup(popup)).orElseGet(() -> (PDAnnotationPopup)this.duplicate(popup, relevantPages));
                    ((PDAnnotationMarkup)duplicate).setPopup(popupDuplicate);
                    if (Objects.nonNull(popupDuplicate.getParent())) {
                        popupDuplicate.setParent((PDAnnotationMarkup)duplicate);
                        LOG.trace("Popup parent annotation updated");
                    }
                    keptAnnotations.add(popupDuplicate);
                } else {
                    ((PDAnnotationMarkup)duplicate).setPopup(null);
                    LOG.warn("Removed Popup annotation of unexpected subtype {}", (Object)subtype);
                }
            }
            keptAnnotations.add(duplicate);
        }
    }

    private PDAnnotation duplicate(PDAnnotation annotation, LookupTable<PDPage> relevantPages) {
        PDPage p = annotation.getPage();
        PDAnnotation duplicate = PDAnnotation.createAnnotation(annotation.getCOSObject().duplicate());
        if (Objects.nonNull(p)) {
            duplicate.setPage(relevantPages.lookup(p));
            LOG.trace("Updated annotation page reference with the looked up page");
        }
        this.annotationsLookup.addLookupEntry(annotation, duplicate);
        return duplicate;
    }

    private PDDestination getDestinationFrom(PDAnnotationLink link) {
        try {
            PDAction action;
            PDDestination destination = link.getDestination();
            if (destination == null && (action = link.getAction()) instanceof PDActionGoTo) {
                destination = ((PDActionGoTo)action).getDestination();
            }
            if (destination instanceof PDNamedDestination) {
                return this.document.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)destination);
            }
            return destination;
        }
        catch (Exception e) {
            LOG.warn("Failed to get destination for annotation", e);
            return null;
        }
    }
}

