/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.impl.sambox.component.split.PagesPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.AbstractSplitByPageParameters;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.parameter.base.MultiplePdfSourceParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByPageNumbersTask<T extends AbstractSplitByPageParameters>
extends BaseTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByPageNumbersTask.class);
    private int totalSteps;
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PagesPdfSplitter<T> splitter;

    @Override
    public void before(T parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = ((MultiplePdfSourceParameters)parameters).getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    @Override
    public void execute(T parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource<?> source : ((MultiplePdfSourceParameters)parameters).getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.document = source.open(this.documentLoader).getUnderlyingPDDocument();
            this.splitter = new PagesPdfSplitter<T>(this.document, parameters, new OptimizationRuler(((AbstractSplitByPageParameters)parameters).getOptimizationPolicy()).apply(this.document));
            LOG.debug("Starting split by page numbers for {} ", (Object)parameters);
            this.splitter.split(this.executionContext(), ((MultiplePdfSourceMultipleOutputParameters)parameters).getOutputPrefix(), source);
            ComponentsUtility.nullSafeCloseQuietly(this.document);
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        LOG.debug("Input documents split and written to {}", (Object)((MultiplePdfSourceMultipleOutputParameters)parameters).getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.document);
        this.splitter = null;
    }
}

