/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SamboxOutlineLevelsHandler;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.impl.sambox.component.split.PageDestinationsLevelPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.outline.OutlinePageDestinations;
import org.sejda.model.parameter.SplitByOutlineLevelParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByOutlineLevelTask
extends BaseTask<SplitByOutlineLevelParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByOutlineLevelTask.class);
    private int totalSteps;
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PageDestinationsLevelPdfSplitter splitter;

    @Override
    public void before(SplitByOutlineLevelParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    @Override
    public void execute(SplitByOutlineLevelParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource<?> source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {} ", (Object)source);
            this.document = source.open(this.documentLoader).getUnderlyingPDDocument();
            LOG.debug("Retrieving outline information for level {}", (Object)parameters.getLevelToSplitAt());
            OutlinePageDestinations pagesDestination = new SamboxOutlineLevelsHandler(this.document, parameters.getMatchingTitleRegEx()).getPageDestinationsForLevel(parameters.getLevelToSplitAt());
            this.splitter = new PageDestinationsLevelPdfSplitter(this.document, parameters, pagesDestination, (boolean)new OptimizationRuler(parameters.getOptimizationPolicy()).apply(this.document));
            LOG.debug("Starting split by outline level for {} ", (Object)parameters);
            this.splitter.split(this.executionContext(), parameters.getOutputPrefix(), source);
            ComponentsUtility.nullSafeCloseQuietly(this.document);
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        LOG.debug("Input documents splitted and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.document);
        this.splitter = null;
    }
}

