/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.SetPagesLabelParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPagesLabelTask
extends BaseTask<SetPagesLabelParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetPagesLabelTask.class);
    private PDDocumentHandler documentHandler = null;
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(SetPagesLabelParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
    }

    @Override
    public void execute(SetPagesLabelParameters parameters) throws TaskException {
        this.executionContext().assertTaskNotCancelled();
        ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).progressUndetermined();
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.documentHandler = source.open(this.documentLoader);
        File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        LOG.debug("Applying {} labels ", (Object)parameters.getLabels().size());
        this.documentHandler.setPageLabelsOnDocument(parameters.getLabels());
        this.documentHandler.setCreatorOnPDDocument();
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Labels applied to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

