/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfScaler;
import org.sejda.impl.sambox.component.SetHeaderFooterWriter;
import org.sejda.impl.sambox.util.FontUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.SetHeaderFooterParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.scale.ScaleType;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetHeaderFooterTask
extends BaseTask<SetHeaderFooterParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetHeaderFooterTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(SetHeaderFooterParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
    }

    @Override
    public void execute(SetHeaderFooterParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource<?> source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.documentHandler = source.open(this.documentLoader);
            this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.MODIFY);
            this.documentHandler.setCreatorOnPDDocument();
            File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
            this.documentHandler.setCompress(parameters.isCompress());
            if (parameters.isAddMargins()) {
                new PdfScaler(ScaleType.CONTENT).scale(this.documentHandler.getUnderlyingPDDocument(), 0.9);
            }
            String originalValue = parameters.getPattern();
            String value = FontUtils.removeUnsupportedCharacters(parameters.getPattern(), this.documentHandler.getUnderlyingPDDocument());
            if (!value.equals(originalValue)) {
                Set<Character> unsupportedChars = org.sejda.core.support.util.StringUtils.difference(originalValue, value);
                String displayUnsupportedChars = StringUtils.join((Iterable)unsupportedChars.stream().map(c -> org.sejda.core.support.util.StringUtils.asUnicodes(c.toString())).collect(Collectors.toList()), ",");
                ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Unsupported characters (%s) were removed: '%s'", displayUnsupportedChars, StringUtils.abbreviate(originalValue, 20)));
            }
            try (SetHeaderFooterWriter footerWriter = new SetHeaderFooterWriter(this.documentHandler);){
                int currentFileCounter = currentStep + parameters.getFileCountStartFrom() - 1;
                String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentFileCounter));
                footerWriter.write(value, parameters, currentFileCounter, outName, this.executionContext());
                this.documentHandler.savePDDocument(tmpFile);
                this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            }
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

