/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfRotator;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.RotateParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RotateTask
extends BaseTask<RotateParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(RotateTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(RotateParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RotateParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource<?> source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            try {
                this.documentHandler = source.open(this.documentLoader);
                this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
                this.documentHandler.setCreatorOnPDDocument();
                File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
                LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
                PdfRotator rotator = new PdfRotator(this.documentHandler.getUnderlyingPDDocument());
                for (Integer page : parameters.getPages(this.documentHandler.getNumberOfPages())) {
                    this.executionContext().assertTaskNotCancelled();
                    try {
                        rotator.rotate(page, parameters.getRotation(page));
                    }
                    catch (PageNotFoundException e) {
                        this.executionContext().assertTaskIsLenient(e);
                        ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be rotated", page), e);
                    }
                }
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile);
                String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
                this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            }
            finally {
                ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents rotated and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

