/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.BasePdfToImageTask;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.base.AbstractParameters;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;
import org.sejda.model.parameter.image.AbstractPdfToSingleImageParameters;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToSingleImageTask<T extends AbstractPdfToSingleImageParameters>
extends BasePdfToImageTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToSingleImageTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener = new DefaultPdfSourceOpener();
    private PDDocumentHandler documentHandler = null;

    @Override
    public void before(T parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        if (!this.getWriter().supportMultiImage()) {
            throw new TaskExecutionException("Selected ImageWriter doesn't support multiple images in the same file");
        }
        this.outputWriter = OutputWriters.newSingleOutputWriter(((AbstractParameters)parameters).getExistingOutputPolicy(), executionContext);
    }

    @Override
    public void execute(T parameters) throws TaskException {
        File tmpFile = IOUtils.createTemporaryBuffer(((AbstractPdfToSingleImageParameters)parameters).getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        LOG.debug("Opening {}", (Object)((AbstractPdfToImageParameters)parameters).getSource());
        this.documentHandler = ((AbstractPdfToImageParameters)parameters).getSource().open(this.sourceOpener);
        int numberOfPages = this.documentHandler.getNumberOfPages();
        LOG.trace("Found {} pages", (Object)numberOfPages);
        this.getWriter().openDestination(tmpFile, parameters);
        for (int page = 1; page <= numberOfPages; ++page) {
            this.executionContext().assertTaskNotCancelled();
            LOG.trace("Converting page {}", (Object)page);
            try {
                BufferedImage pageImage = this.documentHandler.renderImage(page, ((AbstractPdfToImageParameters)parameters).getResolutionInDpi(), ((AbstractPdfToImageParameters)parameters).getOutputImageColorType());
                this.getWriter().write((RenderedImage)pageImage, parameters);
            }
            catch (TaskException e) {
                this.executionContext().assertTaskIsLenient(e);
                ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be converted", page), e);
            }
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(page + 1).outOf(numberOfPages);
        }
        this.getWriter().closeDestination();
        ((AbstractPdfToSingleImageParameters)parameters).getOutput().accept(this.outputWriter);
        LOG.debug("Document converted to {} and saved to {}", (Object)((AbstractPdfToImageParameters)parameters).getOutputImageType(), (Object)((AbstractPdfToSingleImageParameters)parameters).getOutput());
    }

    @Override
    public void after() {
        super.after();
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

