/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfTextExtractorByArea;
import org.sejda.impl.sambox.component.excel.DataTable;
import org.sejda.model.TopLeftRectangularBox;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.excel.PdfToExcelParameters;
import org.sejda.model.parameter.excel.Table;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToExcelTask
extends BaseTask<PdfToExcelParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToExcelTask.class);
    private PDDocumentHandler sourceDocumentHandler = null;
    private PDDocumentHandler destinationDocument = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(PdfToExcelParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
    }

    @Override
    public void execute(PdfToExcelParameters parameters) throws TaskException {
        int currentStep = 0;
        int totalSteps = parameters.getSourceList().size();
        for (PdfSource<?> source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.sourceDocumentHandler = source.open(this.documentLoader);
            File tmpFile = IOUtils.createTemporaryBuffer(".xlsx");
            LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
            this.destinationDocument = new PDDocumentHandler();
            this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
            this.destinationDocument.initialiseBasedOn(this.sourceDocumentHandler.getUnderlyingPDDocument());
            this.destinationDocument.setCompress(parameters.isCompress());
            int numberOfPages = this.sourceDocumentHandler.getNumberOfPages();
            List<DataTable> all = new ArrayList<DataTable>();
            for (int pageNumber = 1; pageNumber <= numberOfPages; ++pageNumber) {
                DataTable dataTable = new DataTable(pageNumber);
                LOG.debug("Extracting tables from page {}", (Object)pageNumber);
                long start = System.currentTimeMillis();
                PDPage page = this.sourceDocumentHandler.getPage(pageNumber);
                for (Table table : parameters.getTables(pageNumber)) {
                    ArrayList<Rectangle> cellAreas = new ArrayList<Rectangle>();
                    for (TopLeftRectangularBox row : table.getRows()) {
                        for (TopLeftRectangularBox column : table.getColumns()) {
                            TopLeftRectangularBox cell = row.intersection(column);
                            if (!cell.asRectangle().isEmpty()) {
                                cellAreas.add(cell.withPadding(1).asRectangle());
                                continue;
                            }
                            LOG.warn("Column and row do not intersect: row: " + row.toString() + ", column: " + column.toString());
                            cellAreas.add(new Rectangle(0, 0, 0, 0));
                        }
                    }
                    LOG.debug("Extracting text for {} table cells", (Object)cellAreas.size());
                    long startTimingCells = System.currentTimeMillis();
                    List<String> cellValues = new PdfTextExtractorByArea().extractTextFromAreas(page, cellAreas);
                    LOG.debug("Text extraction took {} seconds", (Object)((System.currentTimeMillis() - startTimingCells) / 1000L));
                    int i = 0;
                    ArrayList<String> rowData = new ArrayList<String>();
                    for (TopLeftRectangularBox row : table.getRows()) {
                        for (TopLeftRectangularBox column : table.getColumns()) {
                            rowData.add(cellValues.get(i));
                            ++i;
                        }
                        dataTable.addRow(rowData);
                        rowData = new ArrayList();
                    }
                    all.add(dataTable);
                }
                LOG.debug("Done extracting tables from page {}, took {} seconds", (Object)pageNumber, (Object)((System.currentTimeMillis() - start) / 1000L));
            }
            if (parameters.isMergeTablesSpanningMultiplePages()) {
                all = this.mergeTablesSpanningMultiplePages(all);
            }
            this.writeExcelFile(all, tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest("xlsx").originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(totalSteps);
            ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents cropped and written to {}", (Object)parameters.getOutput());
    }

    private List<DataTable> mergeTablesSpanningMultiplePages(List<DataTable> dataTables) {
        ArrayList<DataTable> results = new ArrayList<DataTable>();
        DataTable current = null;
        for (DataTable dt : dataTables) {
            if (current != null) {
                if (current.hasSameColumnsAs(dt)) {
                    current = current.mergeWith(dt);
                    continue;
                }
                results.add(current);
                current = dt;
                continue;
            }
            current = dt;
        }
        if (current != null) {
            results.add(current);
        }
        return results;
    }

    private void writeExcelFile(List<DataTable> dataTables, File tmpFile) throws TaskException {
        LOG.debug("Writing data to excel file");
        long start = System.currentTimeMillis();
        XSSFWorkbook wb = new XSSFWorkbook();
        try (FileOutputStream fileOut = new FileOutputStream(tmpFile);){
            for (int t = 0; t < dataTables.size(); ++t) {
                LOG.debug("Writing data table " + t);
                DataTable dataTable = dataTables.get(t);
                List<List<String>> data = dataTable.getData();
                Sheet sheet = wb.createSheet(String.format("Table %d (%s)", t + 1, dataTable.getPagesAsString()));
                for (int r = 0; r < data.size(); ++r) {
                    List<String> dataRow = data.get(r);
                    LOG.debug("Writing row " + r + " of " + dataRow.size() + " values");
                    Row row = sheet.createRow(r);
                    for (int i = 0; i < dataRow.size(); ++i) {
                        String stringValue = dataRow.get(i);
                        row.createCell(i).setCellValue(stringValue);
                    }
                }
                for (int c = 0; c < sheet.getRow(0).getPhysicalNumberOfCells(); ++c) {
                    sheet.autoSizeColumn(c);
                }
            }
            wb.write((OutputStream)fileOut);
            LOG.debug("Done writing data to excel file, took {} seconds", (Object)((System.currentTimeMillis() - start) / 1000L));
        }
        catch (IOException ioe) {
            throw new TaskException("Could not save .xlsx file", ioe);
        }
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
    }
}

