/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.AcroFormsMerger;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.FilenameFooterWriter;
import org.sejda.impl.sambox.component.OutlineMerger;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfScaler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.impl.sambox.component.TableOfContentsCreator;
import org.sejda.impl.sambox.component.image.ImagesToPdfDocumentConverter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.ImageMergeInput;
import org.sejda.model.input.MergeInput;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.Source;
import org.sejda.model.parameter.MergeParameters;
import org.sejda.model.scale.ScaleType;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.model.toc.ToCPolicy;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTask
extends BaseTask<MergeParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener;
    private int totalSteps;
    private PDDocumentHandler destinationDocument;
    private Queue<Closeable> toClose = new LinkedList<Closeable>();
    private OutlineMerger outlineMerger;
    private AcroFormsMerger acroFormsMerger;
    private TableOfContentsCreator tocCreator;
    private FilenameFooterWriter footerWriter;
    private PDRectangle currentPageSize = PDRectangle.A4;
    private long pagesCounter = 0L;

    @Override
    public void before(MergeParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = parameters.getInputList().size();
        this.sourceOpener = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
        this.outlineMerger = new OutlineMerger(parameters.getOutlinePolicy());
    }

    @Override
    public void execute(MergeParameters parameters) throws TaskException {
        int currentStep = 0;
        File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.setCompress(parameters.isCompress());
        this.acroFormsMerger = new AcroFormsMerger(parameters.getAcroFormPolicy(), this.destinationDocument.getUnderlyingPDDocument());
        this.tocCreator = new TableOfContentsCreator(parameters, this.destinationDocument.getUnderlyingPDDocument());
        this.footerWriter = new FilenameFooterWriter(parameters.isFilenameFooter(), this.destinationDocument.getUnderlyingPDDocument());
        this.convertImageMergeInputToPdf(parameters);
        for (PdfMergeInput input : parameters.getPdfInputList()) {
            LOG.debug("Opening {}", (Object)input.getSource());
            PDDocumentHandler sourceDocumentHandler = input.getSource().open(this.sourceOpener);
            this.toClose.add(sourceDocumentHandler);
            LOG.debug("Adding pages");
            LookupTable<PDPage> pagesLookup = new LookupTable<PDPage>();
            long relativeCounter = 0L;
            for (Integer currentPage : input.getPages(sourceDocumentHandler.getNumberOfPages())) {
                this.executionContext().assertTaskNotCancelled();
                ++this.pagesCounter;
                ++relativeCounter;
                try {
                    PDPage page = sourceDocumentHandler.getPage(currentPage);
                    this.currentPageSize = page.getMediaBox().rotate(page.getRotation());
                    PDPage importedPage = this.destinationDocument.importPage(page);
                    pagesLookup.addLookupEntry(page, importedPage);
                    String sourceBaseName = FilenameUtils.getBaseName(input.getSource().getName());
                    if (this.tocCreator.shouldGenerateToC() && relativeCounter == 1L) {
                        this.tocCreator.pageSizeIfNotSet(this.currentPageSize);
                        if (ToCPolicy.DOC_TITLES == parameters.getTableOfContentsPolicy()) {
                            sourceBaseName = Optional.ofNullable(sourceDocumentHandler.getUnderlyingPDDocument().getDocumentInformation()).map(i -> i.getTitle()).filter(StringUtils::isNotBlank).orElse(sourceBaseName);
                        }
                        this.tocCreator.appendItem(sourceBaseName, this.pagesCounter, importedPage);
                    }
                    this.footerWriter.addFooter(importedPage, sourceBaseName, this.pagesCounter + this.tocCreator.tocNumberOfPages());
                    LOG.trace("Added imported page");
                }
                catch (PageNotFoundException e) {
                    this.executionContext().assertTaskIsLenient(e);
                    ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be processed", currentPage), e);
                }
            }
            relativeCounter = 0L;
            this.outlineMerger.updateOutline(sourceDocumentHandler.getUnderlyingPDDocument(), input.getSource().getName(), pagesLookup);
            LookupTable<PDAnnotation> annotationsLookup = new AnnotationsDistiller(sourceDocumentHandler.getUnderlyingPDDocument()).retainRelevantAnnotations(pagesLookup);
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.acroFormsMerger.mergeForm(sourceDocumentHandler.getUnderlyingPDDocument().getDocumentCatalog().getAcroForm(), annotationsLookup);
            if (parameters.isBlankPageIfOdd()) {
                Optional.ofNullable(this.destinationDocument.addBlankPageIfOdd(this.currentPageSize)).ifPresent(p -> ++this.pagesCounter);
            }
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(this.totalSteps);
        }
        if (this.outlineMerger.hasOutline()) {
            LOG.debug("Adding generated outline");
            this.destinationDocument.setDocumentOutline(this.outlineMerger.getOutline());
        }
        Optional.ofNullable(this.acroFormsMerger.getForm()).filter(f -> !f.getFields().isEmpty()).ifPresent(f -> {
            LOG.debug("Adding generated AcroForm");
            this.destinationDocument.setDocumentAcroForm((PDAcroForm)f);
        });
        if (parameters.isNormalizePageSizes()) {
            LOG.debug("Normalizing page widths to match width of first page");
            new PdfScaler(ScaleType.PAGE).scalePages(this.destinationDocument.getUnderlyingPDDocument());
        }
        if (this.tocCreator.hasToc()) {
            LOG.debug("Adding generated ToC");
            this.tocCreator.addToC();
        }
        this.destinationDocument.savePDDocument(tmpFile);
        this.closeResources();
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents merged correctly and written to {}", (Object)parameters.getOutput());
    }

    private void convertImageMergeInputToPdf(MergeParameters parameters) throws TaskException {
        ArrayList<MergeInput> newInputList = new ArrayList<MergeInput>();
        for (MergeInput input : parameters.getInputList()) {
            if (input instanceof ImageMergeInput) {
                newInputList.add(this.convertImagesToPdfMergeInput((ImageMergeInput)input));
                continue;
            }
            newInputList.add(input);
        }
        parameters.setInputList(newInputList);
    }

    private PdfMergeInput convertImagesToPdfMergeInput(ImageMergeInput image) throws TaskException {
        List<Source<?>> sources = Collections.singletonList(image.getSource());
        PDDocumentHandler converted = new ImagesToPdfDocumentConverter().convert(sources);
        String basename = FilenameUtils.getBaseName(image.getSource().getName());
        String filename = String.format("%s.pdf", basename);
        File convertedTmpFile = IOUtils.createTemporaryBufferWithName(filename);
        converted.setDocumentTitle(basename);
        converted.savePDDocument(convertedTmpFile);
        return new PdfMergeInput(PdfFileSource.newInstanceNoPassword(convertedTmpFile));
    }

    private void closeResources() {
        Closeable current;
        while ((current = this.toClose.poll()) != null) {
            ComponentsUtility.nullSafeCloseQuietly(current);
        }
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
    }

    @Override
    public void after() {
        this.closeResources();
        this.outputWriter = null;
    }
}

