/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import org.apache.commons.lang3.mutable.MutableInt;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.image.ImagesToPdfDocumentConverter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.Source;
import org.sejda.model.parameter.image.JpegToPdfParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpegToPdfTask
extends BaseTask<JpegToPdfParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(JpegToPdfTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private SingleOutputWriter outputWriter;

    @Override
    public void before(JpegToPdfParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.totalSteps = parameters.getSourceList().size();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
    }

    @Override
    public void execute(JpegToPdfParameters parameters) throws TaskException {
        final MutableInt currentStep = new MutableInt(0);
        File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        ImagesToPdfDocumentConverter converter = new ImagesToPdfDocumentConverter(){

            @Override
            public void beforeImage(Source<?> source) throws TaskException {
                JpegToPdfTask.this.executionContext().assertTaskNotCancelled();
                currentStep.increment();
            }

            @Override
            public void afterImage(PDImageXObject image) {
                ApplicationEventsNotifier.notifyEvent(JpegToPdfTask.this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep.getValue()).outOf(JpegToPdfTask.this.totalSteps);
            }

            @Override
            public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
                JpegToPdfTask.this.executionContext().assertTaskIsLenient(e);
                ApplicationEventsNotifier.notifyEvent(JpegToPdfTask.this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Image %s was skipped, could not be processed", source.getName()), e);
            }
        };
        converter.setPageSize(parameters.getPageSize());
        converter.setShouldPageSizeMatchImageSize(parameters.isPageSizeMatchImageSize());
        converter.setPageOrientation(parameters.getPageOrientation());
        converter.setMarginInches(parameters.getMarginInches());
        this.documentHandler = converter.convert(parameters.getSourceList());
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input images written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
        this.outputWriter = null;
    }
}

