/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.Set;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PagesExtractor;
import org.sejda.impl.sambox.component.optimization.OptimizationRuler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.ExtractPagesParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractPagesTask
extends BaseTask<ExtractPagesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractPagesTask.class);
    private PagesExtractor extractor = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocumentHandler sourceDocumentHandler;

    @Override
    public void before(ExtractPagesParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
    }

    @Override
    public void execute(ExtractPagesParameters parameters) throws TaskException {
        int currentStep = 0;
        int totalSteps = parameters.getSourceList().size();
        for (PdfSource<?> source : parameters.getSourceList()) {
            this.executionContext().assertTaskNotCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.sourceDocumentHandler = source.open(this.documentLoader);
            this.sourceDocumentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
            Set<Integer> pages = parameters.getPages(this.sourceDocumentHandler.getNumberOfPages());
            if (pages == null || pages.isEmpty()) {
                throw new TaskExecutionException("No page has been selected for extraction.");
            }
            this.extractor = new PagesExtractor(this.sourceDocumentHandler.getUnderlyingPDDocument());
            this.extractor.setVersion(parameters.getVersion());
            this.extractor.setCompress(parameters.isCompress());
            LOG.debug("Extracting pages {}", (Object)pages);
            this.extractor.retain(pages, this.executionContext());
            File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
            LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
            if (new OptimizationRuler(parameters.getOptimizationPolicy()).apply(this.sourceDocumentHandler.getUnderlyingPDDocument()).booleanValue()) {
                this.extractor.optimize();
            }
            this.extractor.save(tmpFile, parameters.discardOutline());
            ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(currentStep).outOf(totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Pages extracted and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResource();
    }

    private void closeResource() {
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        ComponentsUtility.nullSafeCloseQuietly(this.extractor);
    }
}

