/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.AcroFormsMerger;
import org.sejda.impl.sambox.component.AnnotationsDistiller;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.OutlineMerger;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfRotator;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.FileIndexAndPage;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.CombineReorderParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineReorderTask
extends BaseTask<CombineReorderParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CombineReorderTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener;
    private PDDocumentHandler destinationDocument;
    private List<PDDocumentHandler> documents = new ArrayList<PDDocumentHandler>();
    private Map<PDDocumentHandler, String> documentNames = new HashMap<PDDocumentHandler, String>();
    private AcroFormsMerger acroFormsMerger;
    private LookupTable<PDPage> pagesLookup = new LookupTable();
    private OutlineMerger outlineMerger;

    @Override
    public void before(CombineReorderParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before(parameters, executionContext);
        this.sourceOpener = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy(), executionContext);
        this.outlineMerger = new OutlineMerger(parameters.getOutlinePolicy());
    }

    @Override
    public void execute(CombineReorderParameters parameters) throws TaskException {
        File tmpFile = IOUtils.createTemporaryBuffer(parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.setCompress(parameters.isCompress());
        this.acroFormsMerger = new AcroFormsMerger(parameters.getAcroFormPolicy(), this.destinationDocument.getUnderlyingPDDocument());
        for (PdfSource<?> input : parameters.getSourceList()) {
            LOG.debug("Opening {}", input.getSource());
            PDDocumentHandler sourceDocumentHandler = input.open(this.sourceOpener);
            this.documents.add(sourceDocumentHandler);
            this.documentNames.put(sourceDocumentHandler, input.getName());
        }
        int currentStep = 0;
        int totalSteps = parameters.getPages().size() + this.documents.size();
        PdfRotator rotator = new PdfRotator(this.destinationDocument.getUnderlyingPDDocument());
        PDPage lastPage = null;
        for (int i = 0; i < parameters.getPages().size(); ++i) {
            this.executionContext().assertTaskNotCancelled();
            FileIndexAndPage filePage = parameters.getPages().get(i);
            int pageNum = filePage.getPage();
            if (filePage.isAddBlankPage()) {
                PDRectangle mediaBox = PDRectangle.A4;
                if (lastPage != null) {
                    mediaBox = lastPage.getMediaBox();
                }
                this.destinationDocument.addBlankPage(mediaBox);
            } else {
                try {
                    PDPage newPage;
                    PDPage page = this.documents.get(filePage.getFileIndex()).getPage(pageNum);
                    lastPage = newPage = this.destinationDocument.importPage(page);
                    this.pagesLookup.addLookupEntry(page, newPage);
                    rotator.rotate(i + 1, filePage.getRotation());
                }
                catch (PageNotFoundException e) {
                    this.executionContext().assertTaskIsLenient(e);
                    ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).taskWarning(String.format("Page %d was skipped, could not be processed", pageNum), e);
                }
            }
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(totalSteps);
        }
        for (PDDocumentHandler document : this.documents) {
            this.outlineMerger.updateOutline(document.getUnderlyingPDDocument(), this.documentNames.get(document), this.pagesLookup);
            LookupTable<PDAnnotation> annotationsLookup = new AnnotationsDistiller(document.getUnderlyingPDDocument()).retainRelevantAnnotations(this.pagesLookup);
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.acroFormsMerger.mergeForm(document.getUnderlyingPDDocument().getDocumentCatalog().getAcroForm(), annotationsLookup);
            ApplicationEventsNotifier.notifyEvent(this.executionContext().notifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(totalSteps);
        }
        if (this.outlineMerger.hasOutline()) {
            LOG.debug("Adding generated outline");
            this.destinationDocument.setDocumentOutline(this.outlineMerger.getOutline());
        }
        Optional.ofNullable(this.acroFormsMerger.getForm()).filter(f -> !f.getFields().isEmpty()).ifPresent(f -> {
            LOG.debug("Adding generated AcroForm");
            this.destinationDocument.setDocumentAcroForm((PDAcroForm)f);
        });
        this.destinationDocument.savePDDocument(tmpFile);
        this.closeResources();
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents merged correctly and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResources();
        this.outputWriter = null;
        this.documents.clear();
        this.documentNames.clear();
        this.pagesLookup.clear();
    }

    private void closeResources() {
        for (PDDocumentHandler document : this.documents) {
            ComponentsUtility.nullSafeCloseQuietly(document);
        }
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
    }
}

