/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.PrefixTypesChain;
import org.sejda.core.support.prefix.processor.PrefixUtils;

public final class NameGenerator {
    private String prefix;
    private PrefixTypesChain prefixTypesChain;

    private NameGenerator(String prefix) {
        this.prefix = StringUtils.defaultString(prefix);
        this.prefixTypesChain = new PrefixTypesChain(prefix);
    }

    public static NameGenerator nameGenerator(String prefix) {
        return new NameGenerator(prefix);
    }

    public String generate(NameGenerationRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Unable to generate a name for a null request.");
        }
        String result = PrefixUtils.toSafeFilename(this.prefixTypesChain.process(this.prefix, this.preProcessRequest(request)));
        if (result.length() > 255) {
            String baseName = FilenameUtils.getBaseName(result);
            String ext = FilenameUtils.getExtension(result);
            return baseName.substring(0, 254 - ext.length()) + "." + ext;
        }
        return result;
    }

    private NameGenerationRequest preProcessRequest(NameGenerationRequest request) {
        NameGenerationRequest retVal = request;
        if (request == null) {
            retVal = NameGenerationRequest.nameRequest();
        }
        return retVal;
    }
}

