/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.io.IOUtils;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OutputWriterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OutputWriterHelper.class);

    private OutputWriterHelper() {
    }

    static void moveToFile(Map<String, File> files, File outputFile, ExistingOutputPolicy existingOutputPolicy, TaskExecutionContext executionContext) throws IOException {
        if (outputFile.exists() && !outputFile.isFile()) {
            throw new IOException(String.format("Wrong output destination %s, must be a file.", outputFile));
        }
        if (files.size() != 1) {
            throw new IOException(String.format("Wrong files map size %d, must be 1 to copy to the selected destination %s", files.size(), outputFile));
        }
        for (Map.Entry<String, File> entry : files.entrySet()) {
            OutputWriterHelper.moveFile(entry.getValue(), outputFile, Optional.of(existingOutputPolicy).filter(p -> p != ExistingOutputPolicy.SKIP).orElseGet(() -> {
                LOG.debug("Cannot use {} output policy for single output, replaced with {}", (Object)ExistingOutputPolicy.SKIP, (Object)ExistingOutputPolicy.FAIL);
                return ExistingOutputPolicy.FAIL;
            }), executionContext);
        }
    }

    static void moveToDirectory(Map<String, File> files, File outputDirectory, ExistingOutputPolicy existingOutputPolicy, TaskExecutionContext executionContext) throws IOException {
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new IOException(String.format("Unable to make destination directory tree %s.", outputDirectory));
        }
        if (!outputDirectory.isDirectory()) {
            throw new IOException(String.format("Wrong output destination %s, must be a directory.", outputDirectory));
        }
        for (Map.Entry<String, File> entry : files.entrySet()) {
            if (StringUtils.isBlank(entry.getKey())) {
                throw new IOException(String.format("Unable to move %s to the output directory, no output name specified.", entry.getValue()));
            }
            OutputWriterHelper.moveFile(entry.getValue(), new File(outputDirectory, entry.getKey()), existingOutputPolicy, executionContext);
        }
    }

    static void moveFile(File input, File output, ExistingOutputPolicy existingOutputPolicy, TaskExecutionContext executionContext) throws IOException {
        block6: {
            block5: {
                if (!output.exists()) break block5;
                switch (existingOutputPolicy) {
                    case OVERWRITE: {
                        LOG.debug("Moving {} to {}.", (Object)input, (Object)output);
                        Files.move(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        executionContext.notifiableTaskMetadata().addTaskOutput(output);
                        break block6;
                    }
                    case RENAME: {
                        File newNamedOutput = IOUtils.findNewNameThatDoesNotExist(output);
                        LOG.debug("Output exists {}, will use new name {}.", (Object)output, (Object)newNamedOutput);
                        OutputWriterHelper.doMoveFile(input, newNamedOutput);
                        executionContext.notifiableTaskMetadata().addTaskOutput(newNamedOutput);
                        break block6;
                    }
                    case SKIP: {
                        LOG.info("Skipping already existing output file {}", (Object)output);
                        break block6;
                    }
                    default: {
                        throw new IOException(String.format("Unable to write %s to the already existing file destination %s. (policy is %s)", input, output, existingOutputPolicy));
                    }
                }
            }
            LOG.debug("Moving {} to {}.", (Object)input, (Object)output);
            OutputWriterHelper.doMoveFile(input, output);
            executionContext.notifiableTaskMetadata().addTaskOutput(output);
        }
    }

    private static void doMoveFile(File input, File output) throws IOException {
        try {
            FileUtils.moveFile(input, output);
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("Failed to delete original file")) {
                LOG.warn(ex.getMessage());
                input.deleteOnExit();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyToStreamZipped(Map<String, File> files, OutputStream out) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        for (Map.Entry<String, File> entry : files.entrySet()) {
            FileInputStream input = null;
            if (StringUtils.isBlank(entry.getKey())) {
                throw new IOException(String.format("Unable to copy %s to the output stream, no output name specified.", entry.getValue()));
            }
            try {
                input = new FileInputStream(entry.getValue());
                zipOut.putNextEntry(new ZipEntry(entry.getKey()));
                LOG.debug("Copying {} to zip stream {}.", (Object)entry.getValue(), (Object)entry.getKey());
                org.apache.commons.io.IOUtils.copy((InputStream)input, (OutputStream)zipOut);
            }
            catch (Throwable throwable) {
                org.apache.commons.io.IOUtils.closeQuietly(input);
                OutputWriterHelper.delete(entry.getValue());
                throw throwable;
            }
            org.apache.commons.io.IOUtils.closeQuietly(input);
            OutputWriterHelper.delete(entry.getValue());
        }
        org.apache.commons.io.IOUtils.closeQuietly(zipOut);
    }

    static void copyToStream(File file, OutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            org.apache.commons.io.IOUtils.copy((InputStream)in, out);
        }
        catch (Throwable throwable) {
            org.apache.commons.io.IOUtils.closeQuietly(in);
            OutputWriterHelper.delete(file);
            throw throwable;
        }
        org.apache.commons.io.IOUtils.closeQuietly(in);
        OutputWriterHelper.delete(file);
    }

    private static void delete(File file) {
        if (!file.delete()) {
            LOG.warn("Unable to delete temporary file {}", (Object)file);
        }
    }
}

