/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriterHelper;
import org.sejda.core.support.io.model.PopulatedFileOutput;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.task.TaskExecutionContext;

class DefaultMultipleOutputWriter
implements MultipleOutputWriter {
    private Map<String, File> multipleFiles = new HashMap<String, File>();
    private final ExistingOutputPolicy existingOutputPolicy;
    private final TaskExecutionContext executionContext;

    DefaultMultipleOutputWriter(ExistingOutputPolicy existingOutputPolicy, TaskExecutionContext executionContext) {
        this.existingOutputPolicy = ObjectUtils.defaultIfNull(existingOutputPolicy, ExistingOutputPolicy.FAIL);
        this.executionContext = executionContext;
    }

    @Override
    public void dispatch(FileTaskOutput output) throws IOException {
        throw new IOException("Unsupported FileTaskOutput for a multiple output task.");
    }

    @Override
    public void dispatch(DirectoryTaskOutput output) throws IOException {
        OutputWriterHelper.moveToDirectory(this.multipleFiles, output.getDestination(), this.existingOutputPolicy, this.executionContext);
    }

    @Override
    public void dispatch(FileOrDirectoryTaskOutput output) throws IOException {
        if (this.multipleFiles.size() > 1 || output.getDestination().isDirectory()) {
            OutputWriterHelper.moveToDirectory(this.multipleFiles, output.getDestination(), this.existingOutputPolicy, this.executionContext);
        } else {
            OutputWriterHelper.moveToFile(this.multipleFiles, output.getDestination(), this.existingOutputPolicy, this.executionContext);
        }
    }

    @Override
    public void addOutput(PopulatedFileOutput fileOutput) {
        this.multipleFiles.put(fileOutput.getName(), fileOutput.getFile());
    }
}

