/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.context;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.context.ConfigurationStreamProvider;
import org.sejda.model.exception.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XmlConfigurationStreamProvider
implements ConfigurationStreamProvider {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfigurationStreamProvider.class);
    private static final String USER_CONFIG_FILE_NAME = "sejda.xml";
    private static final String DEFAULT_CONFIG_FILE_NAME = "sejda.default.xml";

    XmlConfigurationStreamProvider() {
    }

    @Override
    public InputStream getConfigurationStream() throws ConfigurationException {
        InputStream configurationStream = this.getConfiguration();
        if (configurationStream == null) {
            throw new ConfigurationException("Unable to find xml configuration file.");
        }
        return configurationStream;
    }

    private InputStream getConfiguration() throws ConfigurationException {
        String userConfigFileName = System.getProperty("sejda.config.file");
        if (StringUtils.isNotBlank(userConfigFileName)) {
            return this.getCustomConfigurationStream(userConfigFileName);
        }
        return this.getDefaultConfigurationStream();
    }

    private InputStream getCustomConfigurationStream(String userConfigFileName) throws ConfigurationException {
        LOG.trace("Loading Sejda configuration form {}", (Object)userConfigFileName);
        InputStream retVal = ClassLoader.getSystemResourceAsStream(userConfigFileName);
        if (retVal == null) {
            try {
                LOG.trace("Searching Sejda configuration on filesystem");
                return new FileInputStream(userConfigFileName);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(String.format("Unable to access the provided configuration file [%s]", userConfigFileName), e);
            }
        }
        return retVal;
    }

    private InputStream getDefaultConfigurationStream() {
        LOG.trace("Loading Sejda configuration form {}", (Object)USER_CONFIG_FILE_NAME);
        InputStream result = Thread.currentThread().getContextClassLoader().getResourceAsStream(USER_CONFIG_FILE_NAME);
        if (result == null) {
            LOG.trace("Couldn't find {}, loading Sejda configuration form default {}", (Object)USER_CONFIG_FILE_NAME, (Object)DEFAULT_CONFIG_FILE_NAME);
            result = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE_NAME);
        }
        return result;
    }
}

