/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.sejda.conversion.PdfFileSourceAdapter;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.input.PdfFileSource;

public class WildcardsPdfFileSourceAdapter {
    private final List<PdfFileSource> sources;

    public WildcardsPdfFileSourceAdapter(String path) {
        block16: {
            this.sources = new ArrayList<PdfFileSource>();
            if (FilenameUtils.getName(path).equalsIgnoreCase("*.pdf")) {
                Path directory = Paths.get(FilenameUtils.getFullPath(path), new String[0]).toAbsolutePath().normalize();
                if (!Files.isDirectory(directory, new LinkOption[0])) {
                    throw new ConversionException("Path '" + directory.toString() + "' is not an existing directory");
                }
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory, "*.pdf");){
                    dirStream.forEach(p -> this.sources.add(PdfFileSource.newInstanceNoPassword(p.toFile())));
                    break block16;
                }
                catch (IOException e) {
                    throw new ConversionException("Unable to list PDF files in " + path, e);
                }
            }
            this.sources.add(new PdfFileSourceAdapter(path).getPdfFileSource());
        }
        this.sources.sort(Comparator.comparing(s -> s.getName()));
    }

    public List<PdfFileSource> getPdfFileSources() {
        return this.sources;
    }
}

