/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.single;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.context.DefaultUserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleOwned;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfDocumentDescriptorProvider;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.support.io.FileType;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.pdfsam.ui.commons.SetDestinationRequest;
import org.pdfsam.ui.commons.ShowPdfDescriptorRequest;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.commons.ToggleChangeListener;
import org.pdfsam.ui.io.BrowsableFileField;
import org.pdfsam.ui.io.ChangedSelectedPdfVersionEvent;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.selection.LoadingStatusIndicatorUpdater;
import org.pdfsam.ui.selection.PasswordFieldPopup;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;

public class SingleSelectionPane
extends VBox
implements ModuleOwned,
PdfDocumentDescriptorProvider,
RestorableView {
    private String ownerModule = "";
    private BrowsableFileField field = new BrowsableFileField(FileType.PDF, RememberingLatestFileChooserWrapper.OpenType.OPEN);
    private Label details = new Label();
    private PdfDocumentDescriptor descriptor;
    private PasswordFieldPopup passwordPopup;
    private Label encryptionIndicator = new Label();
    private MenuItem removeSelected;
    private Consumer<PdfDocumentDescriptor> onLoaded = d -> {
        StaticStudio.eventStudio().broadcast(SetDestinationRequest.requestFallbackDestination(d.getFile(), this.getOwnerModule()), this.getOwnerModule());
        StaticStudio.eventStudio().broadcast(new ChangedSelectedPdfVersionEvent(d.getVersion()), this.getOwnerModule());
    };
    private Consumer<PdfDocumentDescriptor> detailsUpdate = d -> {
        PdfDescriptorLoadingStatus status = d.loadingStatus().getValue();
        if (status == PdfDescriptorLoadingStatus.LOADED || status == PdfDescriptorLoadingStatus.LOADED_WITH_USER_PWD_DECRYPTION) {
            this.details.setText(DefaultI18nContext.getInstance().i18n("Pages: {0}, PDF Version: {1}", Integer.toString(d.pages().getValue()), d.getVersionString()));
        } else if (status == PdfDescriptorLoadingStatus.LOADING) {
            this.details.setText(DefaultI18nContext.getInstance().i18n("Loading..."));
        } else {
            this.details.setText("");
        }
    };
    private Consumer<PdfDocumentDescriptor> encryptionIndicatorUpdate = new Consumer<PdfDocumentDescriptor>(){
        private LoadingStatusIndicatorUpdater updater;
        {
            this.updater = new LoadingStatusIndicatorUpdater((Labeled)SingleSelectionPane.this.encryptionIndicator);
        }

        @Override
        public void accept(PdfDocumentDescriptor t) {
            this.updater.accept(t.loadingStatus().getValue());
        }
    };
    private ChangeListener<PdfDescriptorLoadingStatus> onLoadingStatusChange = (o, oldVal, newVal) -> {
        if (this.descriptor != null & this.descriptor.hasReferences()) {
            this.encryptionIndicatorUpdate.andThen(this.detailsUpdate).andThen(d -> {
                PdfDescriptorLoadingStatus status = d.loadingStatus().getValue();
                if (status == PdfDescriptorLoadingStatus.LOADED || status == PdfDescriptorLoadingStatus.LOADED_WITH_USER_PWD_DECRYPTION) {
                    this.onLoaded.accept((PdfDocumentDescriptor)d);
                }
            }).accept(this.descriptor);
        }
    };
    private ToggleChangeListener<? super FXValidationSupport.ValidationState> onValidState = new ToggleChangeListener<FXValidationSupport.ValidationState>(){

        @Override
        public void onChanged(ObservableValue<? extends FXValidationSupport.ValidationState> observable, FXValidationSupport.ValidationState oldValue, FXValidationSupport.ValidationState newVal) {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                SingleSelectionPane.this.initializeFor(PdfDocumentDescriptor.newDescriptorNoPassword(new File(SingleSelectionPane.this.field.getTextField().getText())));
            } else {
                SingleSelectionPane.this.reset();
            }
        }
    };

    public SingleSelectionPane(String ownerModule) {
        this.getStyleClass().add((Object)"single-selection-pane");
        this.ownerModule = StringUtils.defaultString(ownerModule);
        this.details.getStyleClass().add((Object)"-pdfsam-selection-details");
        this.field.enforceValidation(true, false);
        this.passwordPopup = new PasswordFieldPopup(this.ownerModule);
        this.encryptionIndicator.getStyleClass().addAll((Object[])new String[]{"encryption-status"});
        this.encryptionIndicator.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.descriptor.loadingStatus().getValue() == PdfDescriptorLoadingStatus.ENCRYPTED) {
                this.showPasswordFieldPopup();
            } else if (this.descriptor.loadingStatus().getValue() == PdfDescriptorLoadingStatus.WITH_ERRORS) {
                StaticStudio.eventStudio().broadcast(new ShowStageRequest(), "LogStage");
            }
        });
        HBox.setMargin((Node)this.encryptionIndicator, (Insets)new Insets(0.0, 0.0, 0.0, 2.0));
        this.field.setGraphic((Node)this.encryptionIndicator);
        this.field.getStyleClass().add((Object)"single-selection-top");
        HBox.setHgrow((Node)this.field, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.field, this.details});
        this.field.getTextField().validProperty().addListener(this.onValidState);
        this.initContextMenu();
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    private void initializeFor(PdfDocumentDescriptor docDescriptor) {
        this.invalidateDescriptor();
        PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(this.getOwnerModule());
        this.descriptor = docDescriptor;
        this.descriptor.loadingStatus().addListener((ChangeListener)new WeakChangeListener(this.onLoadingStatusChange));
        this.setContextMenuDisable(false);
        loadEvent.add(this.descriptor);
        StaticStudio.eventStudio().broadcast(loadEvent);
    }

    private void reset() {
        this.invalidateDescriptor();
        this.setContextMenuDisable(true);
        this.encryptionIndicator.setText("");
        this.details.setText("");
    }

    private void disableRemoveMenuItemIfNeeded() {
        this.removeSelected.setDisable(StringUtils.isEmpty(this.field.getTextField().getText()));
    }

    private void setContextMenuDisable(boolean value) {
        this.field.getTextField().getContextMenu().getItems().forEach(i -> i.setDisable(value));
        this.disableRemoveMenuItemIfNeeded();
    }

    private void invalidateDescriptor() {
        if (Objects.nonNull(this.descriptor)) {
            this.descriptor.releaseAll();
        }
    }

    private void showPasswordFieldPopup() {
        Window owner;
        Scene scene = this.getScene();
        if (scene != null && (owner = scene.getWindow()) != null && owner.isShowing()) {
            Point2D nodeCoord = this.encryptionIndicator.localToScene(this.encryptionIndicator.getWidth() / 2.0, this.encryptionIndicator.getHeight() / 1.5);
            double anchorX = Math.round(owner.getX() + scene.getX() + nodeCoord.getX() + 2.0);
            double anchorY = Math.round(owner.getY() + scene.getY() + nodeCoord.getY() + 2.0);
            this.passwordPopup.showFor((Node)this, this.descriptor, anchorX, anchorY);
        }
    }

    @Override
    public PdfDocumentDescriptor getPdfDocumentDescriptor() {
        return this.descriptor;
    }

    protected BrowsableFileField getField() {
        return this.field;
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        if (this.descriptor != null) {
            data.put(StringUtils.defaultString(this.getId()) + "input", this.descriptor.getFile().getAbsolutePath());
            if (new DefaultUserContext().isSavePwdInWorkspaceFile()) {
                data.put(StringUtils.defaultString(this.getId()) + "input.password", this.descriptor.getPassword());
            }
        }
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.getField().getTextField().setText("");
        Optional.ofNullable(data.get(StringUtils.defaultString(this.getId()) + "input")).ifPresent(f -> {
            this.onValidState.disabled(true);
            this.getField().getTextField().setText((String)f);
            this.onValidState.disabled(false);
            this.initializeFor(PdfDocumentDescriptor.newDescriptor(new File((String)f), (String)data.get(StringUtils.defaultString(this.getId()) + "input.password")));
        });
    }

    public void addOnLoaded(Consumer<PdfDocumentDescriptor> onDescriptorLoaded) {
        this.onLoaded = onDescriptorLoaded.andThen(this.onLoaded);
    }

    private void initContextMenu() {
        MenuItem infoItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Document properties"), MaterialDesignIcon.INFORMATION_OUTLINE);
        infoItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        infoItem.setOnAction(e -> Platform.runLater(() -> StaticStudio.eventStudio().broadcast(new ShowPdfDescriptorRequest(this.descriptor))));
        this.removeSelected = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Remove"), MaterialDesignIcon.MINUS);
        this.removeSelected.setOnAction(e -> StaticStudio.eventStudio().broadcast(new ClearModuleEvent(), this.getOwnerModule()));
        MenuItem setDestinationItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Set destination"), MaterialIcon.FLIGHT_LAND);
        setDestinationItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}));
        setDestinationItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(SetDestinationRequest.requestDestination(this.descriptor.getFile(), this.getOwnerModule()), this.getOwnerModule()));
        MenuItem openFileItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Open"), MaterialDesignIcon.FILE_PDF_BOX);
        openFileItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(new OpenFileRequest(this.descriptor.getFile())));
        MenuItem openFolderItem = this.createMenuItem(DefaultI18nContext.getInstance().i18n("Open Folder"), MaterialDesignIcon.FOLDER_OUTLINE);
        openFolderItem.setOnAction(e -> StaticStudio.eventStudio().broadcast(new OpenFileRequest(this.descriptor.getFile().getParentFile())));
        this.field.getTextField().setContextMenu(new ContextMenu(new MenuItem[]{setDestinationItem, new SeparatorMenuItem(), this.removeSelected, new SeparatorMenuItem(), infoItem, openFileItem, openFolderItem}));
    }

    @EventListener
    public void onClearSelected(ClearModuleEvent event) {
        this.field.getTextField().setText("");
        this.disableRemoveMenuItemIfNeeded();
    }

    @EventListener
    public void onLoadDocumentsRequest(PdfLoadRequestEvent loadEvent) {
        loadEvent.getDocuments().stream().findFirst().map(PdfDocumentDescriptor::getFile).ifPresent(this.field::setTextFromFile);
    }

    private MenuItem createMenuItem(String text, GlyphIcons icon) {
        MenuItem item = new MenuItem(text);
        GlyphsDude.setIcon(item, icon, "1.1em");
        item.setDisable(true);
        return item;
    }

    @Override
    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    public void setPromptText(String text) {
        this.field.getTextField().setPromptText(text);
    }
}

