/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.selection.multiple.SelectionTableRowData;
import org.pdfsam.ui.selection.multiple.TooltippedTextFieldTableCell;

public class PageRangesColumn
implements SelectionTableColumn<String> {
    private String tooltipMessage = DefaultI18nContext.getInstance().i18n("Double click to set selected pages (ex: 2 or 5-23 or 2,5-7,12-)");

    public PageRangesColumn() {
    }

    public PageRangesColumn(String tooltipMessage) {
        if (StringUtils.isNoneBlank(tooltipMessage)) {
            this.tooltipMessage = tooltipMessage;
        }
    }

    @Override
    public String getColumnTitle() {
        return DefaultI18nContext.getInstance().i18n("Page ranges");
    }

    @Override
    public ObservableValue<String> getObservableValue(SelectionTableRowData data) {
        return data.pageSelection;
    }

    @Override
    public String getTextValue(String item) {
        return StringUtils.defaultString(item, "");
    }

    @Override
    public Comparator<String> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public TableColumn<SelectionTableRowData, String> getTableColumn() {
        TableColumn tableColumn = SelectionTableColumn.super.getTableColumn();
        tableColumn.setEditable(true);
        tableColumn.setOnEditCommit(t -> ((SelectionTableRowData)t.getTableView().getItems().get((int)t.getTablePosition().getRow())).pageSelection.set((String)t.getNewValue()));
        return tableColumn;
    }

    @Override
    public Callback<TableColumn<SelectionTableRowData, String>, TableCell<SelectionTableRowData, String>> cellFactory() {
        return new Callback<TableColumn<SelectionTableRowData, String>, TableCell<SelectionTableRowData, String>>(){

            public TableCell<SelectionTableRowData, String> call(TableColumn<SelectionTableRowData, String> param) {
                return new TooltippedTextFieldTableCell(PageRangesColumn.this.tooltipMessage);
            }
        };
    }
}

