/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.UUID;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.notification.RemoveNotificationRequestEvent;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;

class Notification
extends VBox {
    private FadeTransition fade = new FadeTransition(Duration.millis((double)500.0), (Node)this);

    Notification(String title, Node content) {
        RequireUtils.requireNotNull(content, "Notification content cannot be blank");
        this.getStyleClass().add((Object)"notification");
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.setId(UUID.randomUUID().toString());
        Button closeButton = GlyphsDude.createIconButton(FontAwesomeIcon.TIMES);
        closeButton.getStyleClass().addAll((Object[])new String[]{"close-button"});
        closeButton.setOnAction(e -> StaticStudio.eventStudio().broadcast(new RemoveNotificationRequestEvent(this.getId())));
        Label titleLabel = new Label(title);
        titleLabel.setPrefWidth(2.147483647E9);
        titleLabel.getStyleClass().add((Object)"notification-title");
        StackPane top = new StackPane(new Node[]{titleLabel, closeButton});
        top.setAlignment(Pos.TOP_RIGHT);
        this.getChildren().addAll((Object[])new Node[]{top, content});
        this.setOpacity(0.0);
        this.setOnMouseEntered(e -> {
            this.fade.stop();
            this.setOpacity(1.0);
        });
        this.setOnMouseClicked(e -> {
            this.setOnMouseEntered(null);
            this.setOnMouseExited(null);
            this.fade.stop();
            StaticStudio.eventStudio().broadcast(new RemoveNotificationRequestEvent(this.getId()));
        });
        this.fade.setFromValue(1.0);
        this.fade.setToValue(0.0);
    }

    void onFade(EventHandler<ActionEvent> onFaded) {
        this.fade.setOnFinished(onFaded);
    }

    void fadeAway(Duration delay) {
        this.fade.stop();
        this.fade.setDelay(delay);
        this.fade.jumpTo(Duration.ZERO);
        this.fade.play();
    }

    void fadeAway() {
        this.fadeAway(Duration.ZERO);
    }
}

