/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.news;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.news.HideNewsPanelRequest;
import org.pdfsam.news.LatestNewsEvent;
import org.pdfsam.ui.news.News;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

public class NewsPanel
extends VBox {
    private VBox newsPanel = new VBox();
    ScrollPane scroll = new ScrollPane((Node)this.newsPanel);

    public NewsPanel() {
        this.getStyleClass().add((Object)"news-panel");
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        Button closeButton = GlyphsDude.createIconButton(FontAwesomeIcon.TIMES);
        closeButton.getStyleClass().addAll((Object[])new String[]{"close-button"});
        closeButton.setOnAction(e -> StaticStudio.eventStudio().broadcast(HideNewsPanelRequest.INSTANCE));
        Label titleLabel = new Label(DefaultI18nContext.getInstance().i18n("What's new"));
        titleLabel.setPrefWidth(2.147483647E9);
        titleLabel.getStyleClass().add((Object)"news-panel-title");
        StackPane top = new StackPane(new Node[]{titleLabel, closeButton});
        top.setAlignment(Pos.TOP_RIGHT);
        this.scroll.getStyleClass().add((Object)"scrollable-news");
        this.scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scroll.setFitToHeight(true);
        this.scroll.setFitToWidth(true);
        this.getChildren().addAll((Object[])new Node[]{top, this.scroll});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onLatestNews(LatestNewsEvent e) {
        Platform.runLater(() -> this.newsPanel.getChildren().addAll((Collection)e.latestNews.stream().map(News::new).collect(Collectors.toList())));
    }
}

