/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.ReferenceStrength;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenButton
extends SplitMenuButton
implements TaskOutputDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(OpenButton.class);
    private String ownerModule = "";
    private File destination;
    private List<File> latestOutput = new ArrayList<File>();
    private ModuleInputOutputType outputType;

    public OpenButton(String ownerModule, ModuleInputOutputType outputType) {
        Objects.requireNonNull(outputType);
        this.outputType = outputType;
        this.ownerModule = StringUtils.defaultString(ownerModule);
        this.setId(ownerModule + ".openButton");
        this.getStyleClass().addAll((Object[])Style.BUTTON.css());
        this.getStyleClass().addAll((Object[])new String[]{"pdfsam-split-button", "footer-open-button"});
        this.setText(DefaultI18nContext.getInstance().i18n("Open"));
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.setVisible(false);
        this.setOnAction(e -> {
            if (this.latestOutput.size() != 1 || !this.openFile(this.latestOutput.get(0))) {
                this.openFile(this.destination);
            }
        });
        StaticStudio.eventStudio().add(TaskExecutionRequestEvent.class, e -> {
            if (e.getModuleId().equals(ownerModule)) {
                this.latestOutput.clear();
                try {
                    if (!Objects.isNull(e.getParameters().getOutput())) {
                        e.getParameters().getOutput().accept(this);
                    }
                }
                catch (TaskOutputVisitException ex) {
                    LOG.warn("This should never happen", ex);
                }
            }
        }, -10, ReferenceStrength.STRONG);
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    private boolean openFile(File file) {
        if (file != null && file.exists()) {
            StaticStudio.eventStudio().broadcast(new OpenFileRequest(file));
            return true;
        }
        return false;
    }

    public void initModules(Collection<Module> modules) {
        modules.forEach(m -> {
            if (m.descriptor().hasInputType(this.outputType)) {
                this.getItems().add((Object)new OpenWithMenuItem((Module)m));
            }
        });
    }

    @EventStation
    public String getOwnerModule() {
        return this.ownerModule;
    }

    @EventListener(priority=-10)
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.latestOutput.addAll(event.getNotifiableTaskMetadata().taskOutput());
    }

    @Override
    public void dispatch(FileTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)GlyphsDude.createIcon(FontAwesomeIcon.FILE_PDF_ALT, "1.6em"));
    }

    @Override
    public void dispatch(DirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)GlyphsDude.createIcon(MaterialDesignIcon.FOLDER_OUTLINE, "1.6em"));
    }

    @Override
    public void dispatch(FileOrDirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)GlyphsDude.createIcon(MaterialDesignIcon.FOLDER_OUTLINE, "1.6em"));
    }

    private class OpenWithMenuItem
    extends MenuItem {
        private OpenWithMenuItem(Module module) {
            this.setText(module.descriptor().getName());
            this.setOnAction(e -> {
                StaticStudio.eventStudio().broadcast(new ClearModuleEvent(), module.id());
                StaticStudio.eventStudio().broadcast(SetActiveModuleRequest.activeteModule(module.id()));
                PdfLoadRequestEvent loadEvent = new PdfLoadRequestEvent(module.id());
                OpenButton.this.latestOutput.stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(loadEvent::add);
                StaticStudio.eventStudio().broadcast(loadEvent, module.id());
            });
        }
    }
}

