/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.log;

import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.commons.ClosePane;
import org.pdfsam.ui.commons.HideOnEscapeHandler;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.log.LogListView;
import org.pdfsam.ui.log.LogPane;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.injector.Auto;

@Auto
public class LogStage
extends Stage {
    @EventStation
    public static final String LOGSTAGE_EVENTSTATION = "LogStage";

    @Inject
    public LogStage(LogPane logPane, LogListView logView, List<Image> logos, StylesConfig styles) {
        BorderPane containerPane = new BorderPane();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.setCenter((Node)logPane);
        containerPane.setBottom((Node)new ClosePane());
        Scene scene = new Scene((Parent)containerPane);
        scene.getStylesheets().addAll(styles.styles());
        scene.setOnKeyReleased((EventHandler)new HideOnEscapeHandler((Window)this));
        this.setScene(scene);
        this.setTitle(DefaultI18nContext.getInstance().i18n("Log register"));
        this.getIcons().addAll(logos);
        this.setMaximized(true);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        this.onShowingProperty().addListener((o, oldVal, newVal) -> logView.scrollToBottomIfShowing());
        StaticStudio.eventStudio().add(logView, LOGSTAGE_EVENTSTATION);
    }

    @EventListener
    void requestShow(ShowStageRequest event) {
        if (!this.isShowing()) {
            this.centerOnScreen();
            this.show();
        }
        this.requestFocus();
    }
}

