/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dialog;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.dialog.LenientExecutionConfirmationDialog;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.sejda.model.exception.TaskNonLenientExecutionException;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class LenientTaskExecutionDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(LenientTaskExecutionDialogController.class);
    private TaskExecutionRequestEvent latest;
    private Provider<LenientExecutionConfirmationDialog> dialog;

    @Inject
    public LenientTaskExecutionDialogController(Provider<LenientExecutionConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener(priority=-2147483647)
    public void request(TaskExecutionRequestEvent event) {
        this.latest = event;
    }

    @EventListener(priority=0x7FFFFFFF)
    public void failed(TaskExecutionFailedEvent event) {
        if (event.getFailingCause() instanceof TaskNonLenientExecutionException && Objects.nonNull(this.latest) && this.dialog.get().response()) {
            this.latest.getParameters().setLenient(true);
            StaticStudio.eventStudio().broadcast(this.latest);
            LOG.info("Re-executing task in lenient mode");
        }
    }
}

