/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import java.util.List;
import javafx.scene.Node;
import javax.inject.Named;
import org.pdfsam.context.BooleanUserPreference;
import org.pdfsam.context.IntUserPreference;
import org.pdfsam.context.StringUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleKeyValueItem;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.LocaleKeyValueItem;
import org.pdfsam.support.io.FileType;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableDirectoryField;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableFileField;
import org.pdfsam.ui.dashboard.preference.PreferenceCheckBox;
import org.pdfsam.ui.dashboard.preference.PreferenceComboBox;
import org.pdfsam.ui.dashboard.preference.PreferenceIntTextField;
import org.pdfsam.ui.dashboard.preference.PreferenceRadioButton;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.log.MaxLogRowsChangedEvent;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.injector.Provides;

public class PreferenceConfig {
    @Provides
    @Named(value="localeCombo")
    public PreferenceComboBox<LocaleKeyValueItem> localeCombo(UserContext userContext) {
        return new PreferenceComboBox<LocaleKeyValueItem>(StringUserPreference.LOCALE, userContext);
    }

    @Provides
    @Named(value="startupModuleCombo")
    public PreferenceComboBox<KeyStringValueItem<String>> startupModuleCombo(List<Module> modules, UserContext userContext) {
        PreferenceComboBox<KeyStringValueItem<String>> startupModuleCombo = new PreferenceComboBox<KeyStringValueItem<String>>(StringUserPreference.STARTUP_MODULE, userContext);
        startupModuleCombo.setId("startupModuleCombo");
        startupModuleCombo.getItems().add(KeyStringValueItem.keyValue("", DefaultI18nContext.getInstance().i18n("Dashboard")));
        modules.stream().map(ModuleKeyValueItem::new).forEach(arg_0 -> startupModuleCombo.getItems().add(arg_0));
        startupModuleCombo.setValue(KeyStringValueItem.keyEmptyValue(userContext.getStartupModule()));
        return startupModuleCombo;
    }

    @Provides
    @Named(value="checkForUpdates")
    public PreferenceCheckBox checkForUpdates(UserContext userContext) {
        PreferenceCheckBox checkForUpdates = new PreferenceCheckBox(BooleanUserPreference.CHECK_UPDATES, DefaultI18nContext.getInstance().i18n("Check for updates at startup"), userContext.isCheckForUpdates(), userContext);
        checkForUpdates.setId("checkForUpdates");
        checkForUpdates.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Set whether new version availability should be checked on startup (restart needed)")));
        checkForUpdates.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        checkForUpdates.getStyleClass().add((Object)"spaced-vitem");
        return checkForUpdates;
    }

    @Provides
    @Named(value="checkForNews")
    public PreferenceCheckBox checkForNews(UserContext userContext) {
        PreferenceCheckBox checkForNews = new PreferenceCheckBox(BooleanUserPreference.CHECK_FOR_NEWS, DefaultI18nContext.getInstance().i18n("Check for news at startup"), userContext.isCheckForNews(), userContext);
        checkForNews.setId("checkForNews");
        checkForNews.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Set whether the application should check for news availability on startup (restart needed)")));
        checkForNews.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        checkForNews.getStyleClass().add((Object)"spaced-vitem");
        return checkForNews;
    }

    @Provides
    @Named(value="playSounds")
    public PreferenceCheckBox playSounds(UserContext userContext) {
        PreferenceCheckBox playSounds = new PreferenceCheckBox(BooleanUserPreference.PLAY_SOUNDS, DefaultI18nContext.getInstance().i18n("Play alert sounds"), userContext.isPlaySounds(), userContext);
        playSounds.setId("playSounds");
        playSounds.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Turn on or off alert sounds")));
        playSounds.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        playSounds.getStyleClass().add((Object)"spaced-vitem");
        return playSounds;
    }

    @Provides
    @Named(value="savePwdInWorkspace")
    public PreferenceCheckBox savePwdInWorkspace(UserContext userContext) {
        PreferenceCheckBox savePwdInWorkspace = new PreferenceCheckBox(BooleanUserPreference.SAVE_PWD_IN_WORKSPACE, DefaultI18nContext.getInstance().i18n("Store passwords when saving a workspace file"), userContext.isSavePwdInWorkspaceFile(), userContext);
        savePwdInWorkspace.setId("savePwdInWorkspace");
        savePwdInWorkspace.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("If an encrypted PDF document has been opened with a password, save the password in the workspace file")));
        savePwdInWorkspace.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        savePwdInWorkspace.getStyleClass().add((Object)"spaced-vitem");
        return savePwdInWorkspace;
    }

    @Provides
    @Named(value="donationNotification")
    public PreferenceCheckBox donationNotification(UserContext userContext) {
        PreferenceCheckBox donationNotification = new PreferenceCheckBox(BooleanUserPreference.DONATION_NOTIFICATION, DefaultI18nContext.getInstance().i18n("Show donation window"), userContext.isDonationNotification(), userContext);
        donationNotification.setId("donationNotification");
        donationNotification.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Turn on or off the notification appearing once in a while and asking the user to support PDFsam with a donation")));
        donationNotification.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        donationNotification.getStyleClass().add((Object)"spaced-vitem");
        return donationNotification;
    }

    @Provides
    @Named(value="fetchPremiumModules")
    public PreferenceCheckBox fetchPremiumModules(UserContext userContext) {
        PreferenceCheckBox donationNotification = new PreferenceCheckBox(BooleanUserPreference.PREMIUM_MODULES, DefaultI18nContext.getInstance().i18n("Show premium features"), userContext.isFetchPremiumModules(), userContext);
        donationNotification.setId("fetchPremiumModules");
        donationNotification.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Set whether the application should fetch and show premium features description in the modules dashboard")));
        donationNotification.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        donationNotification.getStyleClass().add((Object)"spaced-vitem");
        return donationNotification;
    }

    @Provides
    @Named(value="smartRadio")
    public PreferenceRadioButton smartRadio(UserContext userContext) {
        PreferenceRadioButton smartRadio = new PreferenceRadioButton(BooleanUserPreference.SMART_OUTPUT, DefaultI18nContext.getInstance().i18n("Use the selected PDF document directory as output directory"), userContext.isUseSmartOutput(), userContext);
        smartRadio.setId("smartRadio");
        return smartRadio;
    }

    @Provides
    @Named(value="workingDirectory")
    public PreferenceBrowsableDirectoryField workingDirectory(UserContext userContext) {
        PreferenceBrowsableDirectoryField workingDirectory = new PreferenceBrowsableDirectoryField(StringUserPreference.WORKING_PATH, userContext);
        workingDirectory.getTextField().setText(userContext.getDefaultWorkingPath());
        workingDirectory.setId("workingDirectory");
        workingDirectory.getStyleClass().add((Object)"spaced-vitem");
        return workingDirectory;
    }

    @Provides
    @Named(value="workspace")
    public PreferenceBrowsableFileField workspace(UserContext userContext) {
        PreferenceBrowsableFileField workspace = new PreferenceBrowsableFileField(StringUserPreference.WORKSPACE_PATH, FileType.JSON, RememberingLatestFileChooserWrapper.OpenType.OPEN, userContext);
        workspace.getTextField().setText(userContext.getDefaultWorkspacePath());
        workspace.setId("workspace");
        workspace.getStyleClass().add((Object)"spaced-vitem");
        return workspace;
    }

    @Provides
    @Named(value="saveWorkspaceOnExit")
    public PreferenceCheckBox saveWorkspaceOnExit(UserContext userContext) {
        PreferenceCheckBox saveWorkspaceOnExit = new PreferenceCheckBox(BooleanUserPreference.SAVE_WORKSPACE_ON_EXIT, DefaultI18nContext.getInstance().i18n("Save default workspace on exit"), userContext.isSaveWorkspaceOnExit(), userContext);
        saveWorkspaceOnExit.setId("saveWorkspaceOnExit");
        saveWorkspaceOnExit.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("If a default workspace is set, save it on application exit")));
        saveWorkspaceOnExit.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        saveWorkspaceOnExit.getStyleClass().add((Object)"spaced-vitem");
        return saveWorkspaceOnExit;
    }

    @Provides
    @Named(value="logViewRowsNumber")
    public PreferenceIntTextField logViewRowsNumber(UserContext userContext) {
        PreferenceIntTextField logRowsNumber = new PreferenceIntTextField(IntUserPreference.LOGVIEW_ROWS_NUMBER, userContext, Validators.positiveInteger());
        logRowsNumber.setText(Integer.toString(userContext.getNumberOfLogRows()));
        logRowsNumber.setErrorMessage(DefaultI18nContext.getInstance().i18n("Maximum number of rows mast be a positive number"));
        logRowsNumber.setId("logViewRowsNumber");
        logRowsNumber.validProperty().addListener((o, oldVal, newVal) -> {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                StaticStudio.eventStudio().broadcast(new MaxLogRowsChangedEvent());
            }
        });
        return logRowsNumber;
    }
}

