/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.news.ShowNewsPanelRequest;
import org.pdfsam.ui.banner.BannerButton;
import org.pdfsam.ui.commons.Animations;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

class NewsButton
extends BannerButton {
    static final String UP_TO_DATE_CSS_CLASS = "news-not-up-to-date";
    private Timeline anim;

    NewsButton() {
        super(MaterialDesignIcon.NEWSPAPER);
        this.setOnAction(e -> StaticStudio.eventStudio().broadcast(ShowNewsPanelRequest.INSTANCE));
        this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("What's new")));
        this.anim = Animations.shake((Node)this);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    public void setUpToDate(boolean value) {
        if (value) {
            this.getStyleClass().remove((Object)UP_TO_DATE_CSS_CLASS);
            this.anim.stop();
            this.setRotate(0.0);
            this.setScaleY(1.0);
        } else {
            this.getStyleClass().add((Object)UP_TO_DATE_CSS_CLASS);
            this.anim.play();
        }
    }

    @EventListener
    public void onShowNewsPanel(ShowNewsPanelRequest req) {
        this.setUpToDate(true);
    }
}

