/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import java.util.HashMap;
import java.util.List;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.inject.Inject;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.ui.commons.SetActiveModuleRequest;
import org.sejda.eventstudio.StaticStudio;

class ModulesMenu
extends Menu {
    @Inject
    public ModulesMenu(List<Module> modules) {
        super(DefaultI18nContext.getInstance().i18n("_Modules"));
        this.setId("modulesMenu");
        HashMap<ModuleCategory, Menu> moduleSubmenus = new HashMap<ModuleCategory, Menu>();
        for (Module currentModule : modules) {
            ModuleCategory category = currentModule.descriptor().category;
            Menu currentMenu = (Menu)moduleSubmenus.get((Object)category);
            if (currentMenu == null) {
                currentMenu = new Menu(category.getDescription());
                moduleSubmenus.put(category, currentMenu);
            }
            MenuItem moduleMenu = new MenuItem(currentModule.descriptor().getName());
            moduleMenu.setOnAction(e -> StaticStudio.eventStudio().broadcast(SetActiveModuleRequest.activeteModule(currentModule.id())));
            currentMenu.getItems().add((Object)moduleMenu);
        }
        this.getItems().addAll(moduleSubmenus.values());
    }
}

