/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.banner;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ui.banner.BannerButtons;
import org.pdfsam.ui.event.SetTitleEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

public class BannerPane
extends HBox {
    private Label current = new Label();

    @Inject
    public BannerPane(BannerButtons buttons, ImageView payoff, @Named(value="logo32") Image logo) {
        this.getStyleClass().add((Object)"pdfsam-banner");
        this.current.getStyleClass().add((Object)"header-title");
        HBox.setHgrow((Node)buttons, (Priority)Priority.ALWAYS);
        HBox logoView = new HBox();
        logoView.getStyleClass().add((Object)"pdfsam-logo");
        logoView.getChildren().addAll((Object[])new Node[]{new ImageView(logo), payoff});
        this.getChildren().addAll((Object[])new Node[]{logoView, this.current, buttons});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    void onChangeTitle(SetTitleEvent event) {
        if (StringUtils.isNotBlank(event.getTitle())) {
            this.current.setText(String.format("@%s", event.getTitle()));
        } else {
            this.current.setText("");
        }
    }
}

